/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.client.container;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.arquillian.cube.impl.client.CubeConfiguration;
import org.arquillian.cube.impl.util.BindingUtil;
import org.arquillian.cube.impl.util.ContainerUtil;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.core.api.annotation.Observes;

public class ContainerConfigurationController {
    private static final Pattern portPattern = Pattern.compile("(?i:.*port.*)");
    private static final Pattern hostPattern = Pattern.compile("(?i:.*host.*)");
    private static final Pattern addressPattern = Pattern.compile("(?i:.*address.*)");

    public void applyDockerServerIpChange(@Observes BeforeSetup event, CubeRegistry cubeRegistry, ContainerRegistry containerRegistry, CubeConfiguration cubeConfiguration) {
        Container container = ContainerUtil.getContainerByDeployableContainer(containerRegistry, event.getDeployableContainer());
        if (container == null) {
            return;
        }
        ContainerDef containerConfiguration = container.getContainerConfiguration();
        this.resolveConfigurationPropertiesWithDockerServerIp(containerConfiguration, cubeConfiguration);
    }

    public void remapContainer(@Observes BeforeSetup event, CubeRegistry cubeRegistry, ContainerRegistry containerRegistry) throws InstantiationException, IllegalAccessException {
        Container container = ContainerUtil.getContainerByDeployableContainer(containerRegistry, event.getDeployableContainer());
        if (container == null) {
            return;
        }
        Cube cube = cubeRegistry.getCube(container.getName());
        if (cube == null) {
            return;
        }
        Binding binding = BindingUtil.binding(cube.configuration());
        if (binding.arePortBindings()) {
            ContainerDef containerConfiguration = container.getContainerConfiguration();
            List<String> portPropertiesFromArquillianConfigurationFile = this.filterArquillianConfigurationPropertiesByPortAttribute(containerConfiguration);
            Class configurationClass = container.getDeployableContainer().getConfigurationClass();
            List<PropertyDescriptor> configurationClassPortFields = this.filterConfigurationClassPropertiesByPortAttribute(configurationClass);
            Object newConfigurationInstance = configurationClass.newInstance();
            for (PropertyDescriptor configurationClassPortField : configurationClassPortFields) {
                if (portPropertiesFromArquillianConfigurationFile.contains(configurationClassPortField.getName())) continue;
                int containerPort = this.getDefaultPortFromConfigurationInstance(newConfigurationInstance, configurationClass, configurationClassPortField);
                Binding.PortBinding bindingForExposedPort = null;
                bindingForExposedPort = binding.getBindingForExposedPort(Integer.valueOf(containerPort));
                if (bindingForExposedPort == null) continue;
                containerConfiguration.overrideProperty(configurationClassPortField.getName(), Integer.toString(bindingForExposedPort.getBindingPort()));
            }
        }
    }

    private int getDefaultPortFromConfigurationInstance(Object configurationInstance, Class<?> configurationClass, PropertyDescriptor fieldName) {
        try {
            Method method = fieldName.getReadMethod();
            return (Integer)method.invoke(configurationInstance, new Object[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void resolveConfigurationPropertiesWithDockerServerIp(ContainerDef containerDef, CubeConfiguration cubeConfiguration) {
        for (Map.Entry entry : containerDef.getContainerProperties().entrySet()) {
            if (!hostPattern.matcher((CharSequence)entry.getKey()).matches() && !addressPattern.matcher((CharSequence)entry.getKey()).matches() || !((String)entry.getValue()).contains("dockerServerIp")) continue;
            containerDef.overrideProperty((String)entry.getKey(), ((String)entry.getValue()).replaceAll("dockerServerIp", cubeConfiguration.getDockerServerIp()));
        }
    }

    private List<String> filterArquillianConfigurationPropertiesByPortAttribute(ContainerDef containerDef) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Map.Entry entry : containerDef.getContainerProperties().entrySet()) {
            if (!portPattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            fields.add((String)entry.getKey());
        }
        return fields;
    }

    private List<PropertyDescriptor> filterConfigurationClassPropertiesByPortAttribute(Class<?> configurationClass) {
        ArrayList<PropertyDescriptor> fields = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(configurationClass, Object.class).getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                if (!portPattern.matcher(propertyName).matches()) continue;
                fields.add(propertyDescriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        return fields;
    }
}

