/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.spi.Cube;

public class StaticAwaitStrategy
implements AwaitStrategy {
    private static final String PORTS = "ports";
    private static final String IP = "ip";
    public static final String TAG = "static";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private static final int DEFAULT_SLEEP_POLL_TIME = 500;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String POLLING_TIME = "sleepPollingTime";
    private static final String ITERATIONS = "iterations";
    private int pollIterations = 10;
    private int sleepPollTime = 500;
    private TimeUnit timeUnit = DEFAULT_TIME_UNIT;
    private String ip;
    private List<Integer> ports = new ArrayList<Integer>();

    public StaticAwaitStrategy(Cube cube, Map<String, Object> params) {
        this.ip = (String)params.get(IP);
        this.ports.addAll((Collection)params.get(PORTS));
        if (params.containsKey(POLLING_TIME)) {
            this.configurePollingTime(params);
        }
        if (params.containsKey(ITERATIONS)) {
            this.pollIterations = (Integer)params.get(ITERATIONS);
        }
    }

    private void configurePollingTime(Map<String, Object> params) {
        Object sleepTime = params.get(POLLING_TIME);
        if (sleepTime instanceof Integer) {
            this.sleepPollTime = (Integer)sleepTime;
        } else {
            String sleepTimeWithUnit = ((String)sleepTime).trim();
            if (sleepTimeWithUnit.endsWith("ms")) {
                this.timeUnit = TimeUnit.MILLISECONDS;
            } else if (sleepTimeWithUnit.endsWith("s")) {
                this.timeUnit = TimeUnit.SECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf(115)).trim());
            } else {
                this.timeUnit = TimeUnit.MILLISECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf("ms")).trim());
            }
        }
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public boolean await() {
        for (Integer port : this.ports) {
            if (Ping.ping(this.ip, port, this.pollIterations, this.sleepPollTime, TimeUnit.MILLISECONDS)) continue;
            return false;
        }
        return true;
    }

    public String getIp() {
        return this.ip;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public int getPollIterations() {
        return this.pollIterations;
    }

    public int getSleepPollTime() {
        return this.sleepPollTime;
    }
}

