/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.HomeResolverUtil;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.spi.CubeConfiguration;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeDockerConfigurator {
    private static final String EXTENSION_NAME = "docker";
    private static final String UNIX_SOCKET_SCHEME = "unix";
    public static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final String DOCKER_MACHINE_NAME = "DOCKER_MACHINE_NAME";
    @Inject
    @ApplicationScoped
    private InstanceProducer<CubeDockerConfiguration> configurationProducer;
    @Inject
    private Instance<Boot2Docker> boot2DockerInstance;
    @Inject
    private Instance<DockerMachine> dockerMachineInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<OperatingSystemFamily> operatingSystemFamilyInstanceProducer;

    public void configure(@Observes CubeConfiguration event, ArquillianDescriptor arquillianDescriptor) {
        this.operatingSystemFamilyInstanceProducer.set((Object)new OperatingSystemResolver().currentOperatingSystem().getFamily());
        Map<String, String> config = arquillianDescriptor.extension(EXTENSION_NAME).getExtensionProperties();
        config = this.resolveSystemEnvironmentVariables(config);
        config = this.resolveServerUriByOperativeSystem(config);
        config = this.resolveServerIp(config);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(config);
        this.configurationProducer.set((Object)cubeConfiguration);
    }

    private Map<String, String> resolveSystemEnvironmentVariables(Map<String, String> config) {
        if (!config.containsKey("serverUri") && this.isDockerHostSet()) {
            String dockerHostUri = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_HOST);
            config.put("serverUri", dockerHostUri);
        }
        if (!config.containsKey("certPath") && this.isDockerCertPathSet()) {
            String dockerCertPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH);
            config.put("certPath", dockerCertPath);
        }
        if (!config.containsKey("machineName") && this.isDockerMachineNameSet()) {
            String dockerMachineName = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME);
            config.put("machineName", dockerMachineName);
        }
        return config;
    }

    private Map<String, String> resolveServerIp(Map<String, String> config) {
        String dockerServerUri = config.get("serverUri");
        if (dockerServerUri.contains("dockerHost")) {
            dockerServerUri = this.isDockerMachineSet(config) ? this.resolveDockerMachine(dockerServerUri, config.get("machineName"), config.get("dockerMachinePath")) : this.resolveBoot2Docker(dockerServerUri, config.get("boot2dockerPath"));
        }
        config.put("serverUri", dockerServerUri);
        if (!config.containsKey("certPath")) {
            config.put("certPath", HomeResolverUtil.resolveHomeDirectoryChar(this.getDefaultTlsDirectory(config)));
        }
        this.resolveDockerServerIp(config, dockerServerUri);
        return config;
    }

    private void resolveDockerServerIp(Map<String, String> config, String dockerServerUri) {
        URI serverUri = URI.create(dockerServerUri);
        String serverIp = UNIX_SOCKET_SCHEME.equalsIgnoreCase(serverUri.getScheme()) ? "localhost" : serverUri.getHost();
        config.put("dockerServerIp", serverIp);
    }

    private boolean isDockerHostSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_HOST) != null;
    }

    private boolean isDockerCertPathSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH) != null;
    }

    private boolean isDockerMachineNameSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME) != null;
    }

    private boolean isDockerMachineSet(Map<String, String> config) {
        return config.containsKey("machineName");
    }

    private String resolveDockerMachine(String tag, String machineName, String dockerMachinePath) {
        ((DockerMachine)this.dockerMachineInstance.get()).setMachineName(machineName);
        return tag.replaceAll("dockerHost", ((DockerMachine)this.dockerMachineInstance.get()).ip(dockerMachinePath, false));
    }

    private String resolveBoot2Docker(String tag, String boot2DockerPath) {
        return tag.replaceAll("dockerHost", ((Boot2Docker)this.boot2DockerInstance.get()).ip(boot2DockerPath, false));
    }

    private String getDefaultTlsDirectory(Map<String, String> config) {
        if (this.isDockerMachineSet(config)) {
            return "~" + File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + config.get("machineName");
        }
        return "~" + File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm";
    }

    private Map<String, String> resolveServerUriByOperativeSystem(Map<String, String> cubeConfiguration) {
        if (!cubeConfiguration.containsKey("serverUri")) {
            if (this.isDockerMachineSet(cubeConfiguration)) {
                String serverUri = OperatingSystemFamily.MACHINE.getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            } else {
                OperatingSystemFamily operatingSystemFamily = (OperatingSystemFamily)((Object)this.operatingSystemFamilyInstanceProducer.get());
                String serverUri = operatingSystemFamily.getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            }
        }
        return cubeConfiguration;
    }
}

