/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.Converter;
import org.arquillian.cube.docker.impl.docker.compose.ContainerBuilder;
import org.arquillian.cube.docker.impl.util.YamlUtil;
import org.yaml.snakeyaml.Yaml;

public class DockerComposeConverter
implements Converter {
    private Map<String, Object> dockerComposeDefinitionMap = new HashMap<String, Object>();
    private Path dockerComposeRootDirectory;

    private DockerComposeConverter(Path location) throws IOException {
        FileInputStream inputStream = new FileInputStream(location.toFile());
        this.dockerComposeDefinitionMap = (Map)new Yaml().load((InputStream)inputStream);
        this.dockerComposeRootDirectory = location.getParent();
        inputStream.close();
    }

    private DockerComposeConverter(String content) {
        this.dockerComposeDefinitionMap = (Map)new Yaml().load(content);
        this.dockerComposeRootDirectory = Paths.get(".", new String[0]);
    }

    public static DockerComposeConverter create(Path location) {
        try {
            return new DockerComposeConverter(location);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static DockerComposeConverter create(String content) {
        return new DockerComposeConverter(content);
    }

    @Override
    public Map<String, Object> convert() {
        HashMap<String, Object> dockerCubeDefinitionMap = new HashMap<String, Object>();
        Set<String> names = this.dockerComposeDefinitionMap.keySet();
        for (String name : names) {
            Map<String, Object> containerCubeDefinition = this.convertContainer(YamlUtil.asMap(this.dockerComposeDefinitionMap, name));
            dockerCubeDefinitionMap.put(name, containerCubeDefinition);
        }
        return dockerCubeDefinitionMap;
    }

    private Map<String, Object> convertContainer(Map<String, Object> dockerComposeContainerDefinition) {
        ContainerBuilder containerBuilder = new ContainerBuilder(this.dockerComposeRootDirectory);
        Map<String, Object> conf = containerBuilder.build(dockerComposeContainerDefinition);
        if (conf.containsKey("env")) {
            conf.put("env", this.toEnvironment((Properties)conf.get("env")));
        }
        return conf;
    }

    private Collection<String> toEnvironment(Properties properties) {
        HashSet<String> listOfEnvironment = new HashSet<String>();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            listOfEnvironment.add(entry.getKey() + "=" + entry.getValue());
        }
        return listOfEnvironment;
    }
}

