/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;

public abstract class AbstractCliInternetAddressResolver {
    public static final String DOCKERHOST_TAG = "dockerHost";
    private static final Logger log = Logger.getLogger(AbstractCliInternetAddressResolver.class.getName());
    private CommandLineExecutor commandLineExecutor;
    private String cachedIp = null;

    public AbstractCliInternetAddressResolver(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    public String ip(String cliPathExec, boolean force) {
        if (this.cachedIp == null || force) {
            this.cachedIp = this.getIp(cliPathExec);
        }
        return this.cachedIp;
    }

    private String getIp(String cliPathExec) {
        String output = this.commandLineExecutor.execCommand(this.getCommandArguments(cliPathExec));
        Matcher m = this.getIpPattern().matcher(output);
        if (m.find()) {
            String ip = m.group();
            return ip;
        }
        String errorMessage = String.format("Cli Internet address resolver executed %s command and does not return a valid ip. It returned %s.", Arrays.toString(this.getCommandArguments(cliPathExec)), output);
        log.log(Level.SEVERE, errorMessage);
        throw new IllegalArgumentException(errorMessage);
    }

    protected abstract String[] getCommandArguments(String var1);

    protected abstract Pattern getIpPattern();
}

