/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import java.util.Collection;
import java.util.Map;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Binding;

public final class BindingUtil {
    public static final String PORTS_SEPARATOR = "->";
    private static final String NO_GATEWAY = null;

    private BindingUtil() {
    }

    public static Binding binding(DockerClientExecutor executor, String cubeId) {
        InspectContainerResponse inspectResponse = executor.getDockerClient().inspectContainerCmd(cubeId).exec();
        HostConfig hostConfig = inspectResponse.getHostConfig();
        String dockerIp = BindingUtil.getDockerServerIp(executor);
        Binding binding = new Binding(dockerIp);
        for (Map.Entry bind : hostConfig.getPortBindings().getBindings().entrySet()) {
            Ports.Binding[] allBindings;
            for (Ports.Binding bindings : allBindings = (Ports.Binding[])bind.getValue()) {
                binding.addPortBinding(Integer.valueOf(((ExposedPort)bind.getKey()).getPort()), bindings.getHostPort());
            }
        }
        return binding;
    }

    private static String getDockerServerIp(DockerClientExecutor executor) {
        return executor.getDockerServerIp();
    }

    public static Binding binding(Map<String, Object> cubeConfiguration) {
        Binding binding = new Binding(NO_GATEWAY);
        if (cubeConfiguration.containsKey("portBindings")) {
            Collection cubePortBindings = (Collection)cubeConfiguration.get("portBindings");
            for (String cubePortBinding : cubePortBindings) {
                String[] elements = cubePortBinding.split(PORTS_SEPARATOR);
                if (elements.length == 1) {
                    int positionOfProtocolSeparator = elements[0].indexOf("/");
                    String bindingPortValue = elements[0];
                    if (positionOfProtocolSeparator > -1) {
                        bindingPortValue = elements[0].substring(0, positionOfProtocolSeparator);
                    }
                    int exposedPort = Integer.parseInt(bindingPortValue);
                    binding.addPortBinding(Integer.valueOf(exposedPort), Integer.valueOf(exposedPort));
                    continue;
                }
                if (elements.length != 2) continue;
                int exposedPort = elements[1].indexOf("/") > -1 ? Integer.parseInt(elements[1].substring(0, elements[1].indexOf("/"))) : Integer.parseInt(elements[1]);
                int port = Integer.parseInt(elements[0]);
                binding.addPortBinding(Integer.valueOf(exposedPort), Integer.valueOf(port));
            }
        }
        return binding;
    }
}

