/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.ArrayList;
import java.util.Map;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static String[] trim(String[] data) {
        ArrayList<String> result = new ArrayList<String>();
        for (String val : data) {
            String trimmed = val.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result.toArray(new String[0]);
    }

    public static String[] reverse(String[] cubeIds) {
        String[] result = new String[cubeIds.length];
        int n = cubeIds.length - 1;
        for (int i = 0; i < cubeIds.length; ++i) {
            result[n--] = cubeIds[i];
        }
        return result;
    }

    public static Map<String, Object> applyExtendsRules(Map<String, Object> containerConfig) {
        for (Map.Entry<String, Object> containerEntry : containerConfig.entrySet()) {
            Map container = (Map)containerEntry.getValue();
            if (!container.containsKey("extends")) continue;
            String extendsContainer = container.get("extends").toString();
            if (!containerConfig.containsKey(extendsContainer)) {
                throw new IllegalArgumentException(containerEntry.getKey() + " extends a non existing container definition " + extendsContainer);
            }
            Map extendedContainer = (Map)containerConfig.get(extendsContainer);
            for (Map.Entry extendedContainerEntry : extendedContainer.entrySet()) {
                if (container.containsKey(extendedContainerEntry.getKey())) continue;
                container.put(extendedContainerEntry.getKey(), extendedContainerEntry.getValue());
            }
        }
        return containerConfig;
    }
}

