/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.util.AbstractCliInternetAddressResolver;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;

public class DockerMachine
extends AbstractCliInternetAddressResolver {
    private static final String DOCKER_MACHINE_EXEC = "docker-machine";
    private static final Pattern IP_PATTERN = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");
    private String machineName;

    public DockerMachine(CommandLineExecutor commandLineExecutor) {
        super(commandLineExecutor);
    }

    @Override
    protected String[] getCommandArguments(String cliPathExec) {
        if (this.machineName == null) {
            throw new IllegalArgumentException("Machine Name cannot be null");
        }
        return new String[]{this.createDockerMachineCommand(cliPathExec), "ip", this.machineName};
    }

    @Override
    protected Pattern getIpPattern() {
        return IP_PATTERN;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    private String createDockerMachineCommand(String boot2DockerPath) {
        return boot2DockerPath == null ? DOCKER_MACHINE_EXEC : boot2DockerPath;
    }
}

