/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.IOUtil;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;

public class PollingAwaitStrategy
implements AwaitStrategy {
    private static final Logger log = Logger.getLogger(PollingAwaitStrategy.class.getName());
    public static final String TAG = "polling";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private static final int DEFAULT_SLEEP_POLL_TIME = 500;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_POLL_TYPE = "sscommand";
    private int pollIterations = 10;
    private int sleepPollTime = 500;
    private TimeUnit timeUnit = DEFAULT_TIME_UNIT;
    private String type = "sscommand";
    private DockerClientExecutor dockerClientExecutor;
    private Cube<?> cube;

    public PollingAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        if (params.getSleepPollingTime() != null) {
            this.configurePollingTime(params.getSleepPollingTime());
        }
        if (params.getIterations() != null) {
            this.pollIterations = params.getIterations();
        }
        if (params.getType() != null) {
            this.type = params.getType();
        }
    }

    private void configurePollingTime(Object sleepTime) {
        if (sleepTime instanceof Integer) {
            this.sleepPollTime = (Integer)sleepTime;
        } else {
            String sleepTimeWithUnit = ((String)sleepTime).trim();
            if (sleepTimeWithUnit.endsWith("ms")) {
                this.timeUnit = TimeUnit.MILLISECONDS;
            } else if (sleepTimeWithUnit.endsWith("s")) {
                this.timeUnit = TimeUnit.SECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf(115)).trim());
            } else {
                this.timeUnit = TimeUnit.MILLISECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf("ms")).trim());
            }
        }
    }

    public int getPollIterations() {
        return this.pollIterations;
    }

    public int getSleepPollTime() {
        return this.sleepPollTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public boolean await() {
        Binding bindings = this.cube.bindings();
        for (Binding.PortBinding ports : bindings.getPortBindings()) {
            log.fine(String.format("Pinging host %s and port %s with type", bindings.getIP(), ports.getBindingPort(), this.type));
            switch (this.type) {
                case "ping": {
                    if (ports.getBindingPort() == -1) {
                        throw new IllegalArgumentException("Can not use polling of type " + this.type + " on non externally bound port " + ports.getExposedPort());
                    }
                    if (Ping.ping(bindings.getIP(), ports.getBindingPort(), this.pollIterations, this.sleepPollTime, this.timeUnit)) break;
                    return false;
                }
                case "sscommand": {
                    if (Ping.ping(this.dockerClientExecutor, this.cube.getId(), this.resolveCommand("ss", ports.getExposedPort()), this.pollIterations, this.sleepPollTime, this.timeUnit)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private String resolveCommand(String command, int port) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("port", Integer.toString(port));
        String templateContent = IOUtil.asStringPreservingNewLines(PollingAwaitStrategy.class.getResourceAsStream(command + ".sh"));
        return IOUtil.replacePlaceholders(templateContent, values);
    }
}

