/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.AutoStartParser;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.CubeContainers;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.util.AutoStartOrderUtil;

public class AutomaticResolutionAutoStartParser
implements AutoStartParser {
    private List<String> deployableContainers;
    private CubeContainers containerDefinition;

    public AutomaticResolutionAutoStartParser(List<String> deployableContainers, CubeContainers containerDefinitions) {
        this.deployableContainers = deployableContainers;
        this.containerDefinition = containerDefinitions;
    }

    @Override
    public Map<String, AutoStartOrderUtil.Node> parse() {
        HashMap<String, AutoStartOrderUtil.Node> nodes = new HashMap<String, AutoStartOrderUtil.Node>();
        for (String deployableContainer : this.deployableContainers) {
            CubeContainer content = this.containerDefinition.get(deployableContainer);
            if (content == null) {
                return nodes;
            }
            if (content.getLinks() == null) continue;
            Collection<Link> links = content.getLinks();
            for (Link link : links) {
                String name = link.getName();
                if (this.containerDefinition.get(name) == null) continue;
                AutoStartOrderUtil.Node child = AutoStartOrderUtil.Node.from(name);
                nodes.put(name, child);
            }
        }
        return nodes;
    }

    public String toString() {
        return AutoStartOrderUtil.toString(this.parse());
    }
}

