/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Binding;

public final class BindingUtil {
    public static final String PORTS_SEPARATOR = "->";

    private BindingUtil() {
    }

    public static Binding binding(DockerClientExecutor executor, String cubeId) {
        InspectContainerResponse inspectResponse = executor.getDockerClient().inspectContainerCmd(cubeId).exec();
        String dockerIp = BindingUtil.getDockerServerIp(executor);
        Binding binding = new Binding(dockerIp);
        HostConfig hostConfig = inspectResponse.getHostConfig();
        if (hostConfig.getPortBindings() != null) {
            for (Map.Entry bind : hostConfig.getPortBindings().getBindings().entrySet()) {
                Ports.Binding[] allBindings;
                for (Ports.Binding bindings : allBindings = (Ports.Binding[])bind.getValue()) {
                    binding.addPortBinding(Integer.valueOf(((ExposedPort)bind.getKey()).getPort()), bindings.getHostPort());
                }
            }
        } else {
            ContainerConfig connectionConfig = inspectResponse.getConfig();
            for (ExposedPort port : connectionConfig.getExposedPorts()) {
                binding.addPortBinding(Integer.valueOf(port.getPort()), Integer.valueOf(-1));
            }
        }
        return binding;
    }

    private static String getDockerServerIp(DockerClientExecutor executor) {
        return executor.getDockerServerIp();
    }

    public static Binding binding(CubeContainer cubeConfiguration, DockerClientExecutor executor) {
        Binding binding = new Binding(executor.getDockerServerIp());
        if (cubeConfiguration.getPortBindings() != null) {
            for (PortBinding cubePortBinding : cubeConfiguration.getPortBindings()) {
                binding.addPortBinding(Integer.valueOf(cubePortBinding.getExposedPort().getExposed()), Integer.valueOf(cubePortBinding.getBound()));
            }
        }
        return binding;
    }
}

