/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Top {
    static final String DOCKER_SOCK = "docker.sock";
    static final String DOCKERINIT = ".dockerinit";
    static final String DOCKERENV = ".dockerenv";
    private String rootDockerFile = "/";
    private String rootDockerSocket = "/var/run/";
    private final Path dockerEnvPath;
    private final Path dockerInitPath;
    private final Path dockerSocketFile;

    public Top() {
        this.dockerEnvPath = Paths.get(this.rootDockerFile, DOCKERENV);
        this.dockerInitPath = Paths.get(this.rootDockerFile, DOCKERINIT);
        this.dockerSocketFile = Paths.get(this.rootDockerSocket, DOCKER_SOCK);
    }

    public Top(String rootDockerFile, String rootDockerSocket) {
        this.rootDockerFile = rootDockerFile;
        this.rootDockerSocket = rootDockerSocket;
        this.dockerEnvPath = Paths.get(rootDockerFile, DOCKERENV);
        this.dockerInitPath = Paths.get(rootDockerFile, DOCKERINIT);
        this.dockerSocketFile = Paths.get(rootDockerSocket, DOCKER_SOCK);
    }

    public boolean isSpinning() {
        return Files.exists(this.dockerEnvPath, new LinkOption[0]) && Files.exists(this.dockerInitPath, new LinkOption[0]) && Files.exists(this.dockerSocketFile, new LinkOption[0]);
    }
}

