/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.await.NativeAwaitStrategy;
import org.arquillian.cube.docker.impl.await.PollingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.StaticAwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;

public class AwaitStrategyFactory {
    private static final Logger log = Logger.getLogger(AwaitStrategyFactory.class.getName());

    private AwaitStrategyFactory() {
    }

    public static final AwaitStrategy create(DockerClientExecutor dockerClientExecutor, Cube<?> cube, CubeContainer options) {
        if (options.getAwait() != null) {
            Await await = options.getAwait();
            if (await.getStrategy() != null) {
                String strategy;
                switch (strategy = await.getStrategy().toLowerCase()) {
                    case "polling": {
                        return new PollingAwaitStrategy(cube, dockerClientExecutor, await);
                    }
                    case "native": {
                        return new NativeAwaitStrategy(cube, dockerClientExecutor);
                    }
                    case "static": {
                        return new StaticAwaitStrategy(cube, await);
                    }
                    case "sleeping": {
                        return new SleepingAwaitStrategy(cube, await);
                    }
                }
                return new NativeAwaitStrategy(cube, dockerClientExecutor);
            }
            log.fine("No await strategy is set and Native one is going to be used.");
            return new PollingAwaitStrategy(cube, dockerClientExecutor, new Await());
        }
        log.fine("No await strategy is set and Polling strategy is going to be used.");
        return new PollingAwaitStrategy(cube, dockerClientExecutor, new Await());
    }
}

