/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.metadata.HasPortBindings;

public class PollingAwaitStrategy
implements AwaitStrategy {
    private static final Logger log = Logger.getLogger(PollingAwaitStrategy.class.getName());
    public static final String TAG = "polling";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private static final int DEFAULT_SLEEP_POLL_TIME = 500;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_POLL_TYPE = "sscommand";
    private int pollIterations = 10;
    private int sleepPollTime = 500;
    private TimeUnit timeUnit = DEFAULT_TIME_UNIT;
    private String type = "sscommand";
    private DockerClientExecutor dockerClientExecutor;
    private Cube<?> cube;
    private List<Integer> ports = null;

    public PollingAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        if (params.getSleepPollingTime() != null) {
            this.configurePollingTime(params.getSleepPollingTime());
        }
        if (params.getIterations() != null) {
            this.pollIterations = params.getIterations();
        }
        if (params.getType() != null) {
            this.type = params.getType();
        }
        if (params.getPorts() != null) {
            this.ports = params.getPorts();
        }
    }

    private void configurePollingTime(Object sleepTime) {
        if (sleepTime instanceof Integer) {
            this.sleepPollTime = (Integer)sleepTime;
        } else {
            String sleepTimeWithUnit = ((String)sleepTime).trim();
            if (sleepTimeWithUnit.endsWith("ms")) {
                this.timeUnit = TimeUnit.MILLISECONDS;
            } else if (sleepTimeWithUnit.endsWith("s")) {
                this.timeUnit = TimeUnit.SECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf(115)).trim());
            } else {
                this.timeUnit = TimeUnit.MILLISECONDS;
                this.sleepPollTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf("ms")).trim());
            }
        }
    }

    public int getPollIterations() {
        return this.pollIterations;
    }

    public int getSleepPollTime() {
        return this.sleepPollTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getType() {
        return this.type;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    public boolean await() {
        HasPortBindings portBindings = (HasPortBindings)this.cube.getMetadata(HasPortBindings.class);
        if (portBindings == null) {
            log.fine("Cube does not have any ports to ping.");
            return true;
        }
        Collection<Integer> pingPorts = this.ports;
        if (this.ports == null) {
            pingPorts = portBindings.getBoundPorts();
        }
        block8: for (Integer port : pingPorts) {
            switch (this.type) {
                case "ping": {
                    HasPortBindings.PortAddress mapping = portBindings.getMappedAddress(port.intValue());
                    if (mapping == null) {
                        throw new IllegalArgumentException("Can not use polling of type " + this.type + " on non externally bound port " + port);
                    }
                    log.fine(String.format("Pinging host %s and port %s with type", mapping.getIP(), mapping.getPort(), this.type));
                    if (Ping.ping(mapping.getIP(), mapping.getPort(), this.pollIterations, this.sleepPollTime, this.timeUnit)) continue block8;
                    return false;
                }
                case "sscommand": {
                    if (Ping.ping(this.dockerClientExecutor, this.cube.getId(), this.resolveCommand("ss", port), this.pollIterations, this.sleepPollTime, this.timeUnit)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private String resolveCommand(String command, int port) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("port", Integer.toString(port));
        String templateContent = IOUtil.asStringPreservingNewLines((InputStream)PollingAwaitStrategy.class.getResourceAsStream(command + ".sh"));
        return IOUtil.replacePlaceholders((String)templateContent, values);
    }
}

