/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.spi.Cube;

public class SleepingAwaitStrategy
implements AwaitStrategy {
    private static final Logger log = Logger.getLogger(SleepingAwaitStrategy.class.getName());
    public static final String TAG = "sleeping";
    private static final int DEFAULT_SLEEP_TIME = 500;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    private int sleepTime = 500;
    private TimeUnit timeUnit = DEFAULT_TIME_UNIT;

    public SleepingAwaitStrategy(Cube<?> cube, Await params) {
        if (params.getSleepTime() != null) {
            this.configureSleepingTime(params.getSleepTime());
        }
    }

    private void configureSleepingTime(Object sleepTime) {
        if (sleepTime instanceof Integer) {
            this.sleepTime = (Integer)sleepTime;
        } else {
            String sleepTimeWithUnit = ((String)sleepTime).trim();
            if (sleepTimeWithUnit.endsWith("ms")) {
                this.timeUnit = TimeUnit.MILLISECONDS;
            } else if (sleepTimeWithUnit.endsWith("s")) {
                this.timeUnit = TimeUnit.SECONDS;
                this.sleepTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf(115)).trim());
            } else {
                this.timeUnit = TimeUnit.MILLISECONDS;
                this.sleepTime = Integer.parseInt(sleepTimeWithUnit.substring(0, sleepTimeWithUnit.indexOf("ms")).trim());
            }
        }
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public boolean await() {
        try {
            this.timeUnit.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, e.getMessage());
        }
        return true;
    }
}

