/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.HostUriContext;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.GitHubUtil;
import org.arquillian.cube.docker.impl.util.HomeResolverUtil;
import org.arquillian.cube.docker.impl.util.Machine;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.spi.CubeConfiguration;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.net.DownloadTool;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeDockerConfigurator {
    private static Logger log = Logger.getLogger(CubeDockerConfigurator.class.getName());
    private static final String EXTENSION_NAME = "docker";
    private static final String UNIX_SOCKET_SCHEME = "unix";
    public static final String DOCKER_HOST = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final String DOCKER_MACHINE_NAME = "DOCKER_MACHINE_NAME";
    @Inject
    @ApplicationScoped
    private InstanceProducer<CubeDockerConfiguration> configurationProducer;
    @Inject
    @ApplicationScoped
    private InstanceProducer<HostUriContext> hostUriContextInstanceProducer;
    @Inject
    private Instance<Boot2Docker> boot2DockerInstance;
    @Inject
    private Instance<DockerMachine> dockerMachineInstance;
    @Inject
    private Instance<Top> topInstance;
    @Inject
    @ApplicationScoped
    private InstanceProducer<OperatingSystemFamily> operatingSystemFamilyInstanceProducer;

    public void configure(@Observes CubeConfiguration event, ArquillianDescriptor arquillianDescriptor) {
        this.configure(arquillianDescriptor);
    }

    private void configure(ArquillianDescriptor arquillianDescriptor) {
        this.operatingSystemFamilyInstanceProducer.set((Object)new OperatingSystemResolver().currentOperatingSystem().getFamily());
        Map<String, String> config = arquillianDescriptor.extension(EXTENSION_NAME).getExtensionProperties();
        config = this.resolveSystemEnvironmentVariables(config);
        config = this.resolveDockerInsideDocker(config);
        config = this.resolveDownloadDockerMachine(config);
        config = this.resolveAutoStartDockerMachine(config);
        config = this.resolveDefaultDockerMachine(config);
        config = this.resolveServerUriByOperativeSystem(config);
        config = this.resolveServerUriTcpProtocol(config);
        config = this.resolveServerIp(config);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(config);
        System.out.println(cubeConfiguration);
        this.hostUriContextInstanceProducer.set((Object)new HostUriContext(cubeConfiguration.getDockerServerUri()));
        this.configurationProducer.set((Object)cubeConfiguration);
    }

    private Map<String, String> resolveDockerInsideDocker(Map<String, String> cubeConfiguration) {
        if ((!cubeConfiguration.containsKey("dockerInsideDockerResolution") || Boolean.parseBoolean(cubeConfiguration.get("dockerInsideDockerResolution"))) && ((Top)this.topInstance.get()).isSpinning()) {
            log.fine(String.format("Your Cube tests are going to run inside a running Docker container. %s property is replaced to %s", "serverUri", OperatingSystemFamily.DIND.getServerUri()));
            String serverUri = OperatingSystemFamily.DIND.getServerUri();
            cubeConfiguration.put("serverUri", serverUri);
        }
        return cubeConfiguration;
    }

    private Map<String, String> resolveDownloadDockerMachine(Map<String, String> config) {
        if (config.containsKey("machineName")) {
            String cliPathExec = config.get("dockerMachinePath");
            if (!((DockerMachine)this.dockerMachineInstance.get()).isDockerMachineInstalled(cliPathExec)) {
                String machineVersion = GitHubUtil.getDockerMachineLatestVersion();
                String machineCustomPath = config.get("dockerMachineCustomPath");
                String machineArquillianPath = CubeDockerConfiguration.resolveMachinePath(machineCustomPath, machineVersion);
                File dockerMachineFile = new File(machineArquillianPath);
                boolean dockerMachineFileExist = dockerMachineFile != null && dockerMachineFile.exists();
                String machineName = config.get("machineName");
                String machineUrl = CubeDockerConfiguration.resolveUrl(machineVersion);
                if (!dockerMachineFileExist) {
                    ((DownloadTool)Spacelift.task(DownloadTool.class)).from(machineUrl).to(dockerMachineFile).execute().await();
                    config.put("dockerMachinePath", dockerMachineFile.getAbsolutePath());
                    ((DockerMachine)this.dockerMachineInstance.get()).grantPermissionToDockerMachine(machineArquillianPath);
                    String machineDriver = config.get("machineDriver");
                    ((DockerMachine)this.dockerMachineInstance.get()).createMachine(machineArquillianPath, machineDriver, machineName);
                } else {
                    config.put("dockerMachinePath", dockerMachineFile.getAbsolutePath());
                }
            }
        }
        return config;
    }

    private Map<String, String> resolveAutoStartDockerMachine(Map<String, String> config) {
        if (config.containsKey("machineName")) {
            String cliPathExec = config.get("dockerMachinePath");
            if (((DockerMachine)this.dockerMachineInstance.get()).isDockerMachineInstalled(cliPathExec)) {
                String machineName = config.get("machineName");
                Set<Machine> machines = ((DockerMachine)this.dockerMachineInstance.get()).list(cliPathExec, "name", machineName);
                if (machines.size() == 1) {
                    Machine machine = this.getFirstMachine(machines);
                    if (machine.getState().equalsIgnoreCase("Stopped")) {
                        ((DockerMachine)this.dockerMachineInstance.get()).startDockerMachine(cliPathExec, machineName);
                    }
                } else {
                    log.log(Level.SEVERE, String.format("You are trying to run containers in Docker Machine %s but %s Docker Machines instances are installed.", config.get("machineName"), machines));
                }
            } else {
                log.log(Level.SEVERE, String.format("You are trying to run containers in Docker Machine %s but no docker-machine installed.", config.get("machineName")));
            }
        }
        return config;
    }

    private Map<String, String> resolveDefaultDockerMachine(Map<String, String> config) {
        if (!config.containsKey("serverUri") && !config.containsKey("machineName")) {
            Set<Machine> machines;
            log.fine("No DockerUri or DockerMachine has been set, let's see if there is only one Docker Machine Running.");
            if (((DockerMachine)this.dockerMachineInstance.get()).isDockerMachineInstalled(config.get("dockerMachinePath")) && (machines = ((DockerMachine)this.dockerMachineInstance.get()).list(config.get("dockerMachinePath"), "state", "Running")).size() == 1) {
                log.fine(String.format("One Docker Machine is running (%s) and it is going to be used for tests", machines.iterator().next().getName()));
                config.put("machineName", this.getFirstMachine(machines).getName());
            }
        }
        return config;
    }

    private Machine getFirstMachine(Set<Machine> machines) {
        return machines.iterator().next();
    }

    private Map<String, String> resolveSystemEnvironmentVariables(Map<String, String> config) {
        if (!config.containsKey("serverUri") && this.isDockerHostSet()) {
            String dockerHostUri = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_HOST);
            config.put("serverUri", dockerHostUri);
        }
        if (!config.containsKey("certPath") && this.isDockerCertPathSet()) {
            String dockerCertPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH);
            config.put("certPath", dockerCertPath);
        }
        if (!config.containsKey("machineName") && this.isDockerMachineNameSet()) {
            String dockerMachineName = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME);
            config.put("machineName", dockerMachineName);
        }
        return config;
    }

    private Map<String, String> resolveServerIp(Map<String, String> config) {
        String dockerServerUri = config.get("serverUri");
        if (this.containsDockerHostTag(dockerServerUri)) {
            dockerServerUri = this.isDockerMachineSet(config) ? this.resolveDockerMachine(dockerServerUri, config.get("machineName"), config.get("dockerMachinePath")) : this.resolveBoot2Docker(dockerServerUri, config.get("boot2dockerPath"));
        }
        config.put("serverUri", dockerServerUri);
        if (!config.containsKey("certPath")) {
            config.put("certPath", HomeResolverUtil.resolveHomeDirectoryChar(this.getDefaultTlsDirectory(config)));
        }
        this.resolveDockerServerIp(config, dockerServerUri);
        return config;
    }

    private boolean containsDockerHostTag(String dockerServerUri) {
        return dockerServerUri.contains("dockerHost");
    }

    private void resolveDockerServerIp(Map<String, String> config, String dockerServerUri) {
        URI serverUri = URI.create(dockerServerUri);
        String serverIp = UNIX_SOCKET_SCHEME.equalsIgnoreCase(serverUri.getScheme()) ? "localhost" : serverUri.getHost();
        config.put("dockerServerIp", serverIp);
    }

    private boolean isDockerHostSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_HOST) != null;
    }

    private boolean isDockerCertPathSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH) != null;
    }

    private boolean isDockerMachineNameSet() {
        return SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME) != null;
    }

    private boolean isDockerMachineSet(Map<String, String> config) {
        return config.containsKey("machineName");
    }

    private String resolveDockerMachine(String tag, String machineName, String dockerMachinePath) {
        ((DockerMachine)this.dockerMachineInstance.get()).setMachineName(machineName);
        return tag.replaceAll("dockerHost", ((DockerMachine)this.dockerMachineInstance.get()).ip(dockerMachinePath, false));
    }

    private String resolveBoot2Docker(String tag, String boot2DockerPath) {
        return tag.replaceAll("dockerHost", ((Boot2Docker)this.boot2DockerInstance.get()).ip(boot2DockerPath, false));
    }

    private String getDefaultTlsDirectory(Map<String, String> config) {
        if (this.isDockerMachineSet(config)) {
            return "~" + File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + config.get("machineName");
        }
        return "~" + File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm";
    }

    private Map<String, String> resolveServerUriTcpProtocol(Map<String, String> cubeConfiguration) {
        String dockerUri;
        if (cubeConfiguration.containsKey("serverUri") && (dockerUri = cubeConfiguration.get("serverUri")) != null && dockerUri.startsWith("tcp://")) {
            if (this.containsCertPath(cubeConfiguration) || this.isDockerMachineNameSet() || this.containsDockerHostTag(dockerUri)) {
                cubeConfiguration.put("serverUri", dockerUri.replace("tcp://", "https://"));
            } else {
                cubeConfiguration.put("serverUri", dockerUri.replace("tcp://", "http://"));
            }
        }
        return cubeConfiguration;
    }

    private boolean containsCertPath(Map<String, String> cubeConfiguration) {
        return cubeConfiguration.containsKey("certPath");
    }

    private Map<String, String> resolveServerUriByOperativeSystem(Map<String, String> cubeConfiguration) {
        if (!cubeConfiguration.containsKey("serverUri")) {
            if (this.isDockerMachineSet(cubeConfiguration)) {
                String serverUri = OperatingSystemFamily.MACHINE.getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            } else {
                OperatingSystemFamily operatingSystemFamily = (OperatingSystemFamily)((Object)this.operatingSystemFamilyInstanceProducer.get());
                String serverUri = operatingSystemFamily.getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            }
        }
        return cubeConfiguration;
    }
}

