/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.metadata;

import java.util.EnumSet;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.impl.reporter.DockerContainerSection;
import org.arquillian.cube.impl.reporter.DockerReportKey;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.metadata.CanReportMetrics;
import org.arquillian.reporter.api.builder.Reporter;
import org.arquillian.reporter.api.builder.report.ReportBuilder;
import org.arquillian.reporter.api.builder.report.ReportInSectionBuilder;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.model.StringKey;

public class ReportMetrics
implements CanReportMetrics {
    private DockerCube dockerCube;

    public ReportMetrics(DockerCube dockerCube) {
        this.dockerCube = dockerCube;
    }

    public ReportInSectionBuilder report() {
        boolean error = EnumSet.of(Cube.State.START_FAILED, Cube.State.CREATE_FAILED, Cube.State.STOP_FAILED, Cube.State.DESTORY_FAILED).contains(this.dockerCube.state());
        ReportBuilder reportBuilder = Reporter.createReport((StringKey)DockerReportKey.DOCKER_CONTAINER_CONFIGURATION).addKeyValueEntry(DockerReportKey.CONTAINER_NAME, this.dockerCube.getId()).addKeyValueEntry(DockerReportKey.ERROR_DURING_LIFECYCLE, Boolean.toString(error)).addKeyValueEntry(DockerReportKey.STARTING_TIME, String.format("%s ms", this.dockerCube.getStartingTimeInMillis())).addKeyValueEntry(DockerReportKey.STOPPING_TIME, String.format("%s ms", this.dockerCube.getStoppingTimeInMillis()));
        CubeContainer configuration = this.dockerCube.configuration();
        if (configuration.getImage() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.IMAGE_NAME, configuration.getImage().toString());
        } else {
            reportBuilder.addKeyValueEntry(DockerReportKey.BUILD_LOCATION, configuration.getBuildImage().getDockerfileLocation());
        }
        if (configuration.getExposedPorts() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.EXPOSED_PORTS, configuration.getExposedPorts().toString());
        }
        if (configuration.getPortBindings() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.PORT_BINDING, configuration.getPortBindings().toString());
        }
        if (configuration.getLinks() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.LINKS, configuration.getLinks().toString());
        }
        if (configuration.getVolumes() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.VOLUMES, configuration.getVolumes().toString());
        }
        if (configuration.getBinds() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.BINDS, configuration.getBinds().toString());
        }
        if (configuration.getEntryPoint() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.ENTRY_POINT, configuration.getEntryPoint().toString());
        }
        if (configuration.getNetworkMode() != null) {
            reportBuilder.addKeyValueEntry(DockerReportKey.NETWORK_MODE, configuration.getNetworkMode());
        }
        return reportBuilder.inSection((SectionEvent)new DockerContainerSection(this.dockerCube.getId()));
    }
}

