/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateNetworkCmd;
import com.github.dockerjava.api.command.CreateNetworkResponse;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.command.StartContainerCmd;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.command.TopContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.InternetProtocol;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Network;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import com.github.dockerjava.core.command.WaitContainerResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import org.arquillian.cube.ChangeLog;
import org.arquillian.cube.TopContainer;
import org.arquillian.cube.docker.impl.await.StatsLogsResultCallback;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.IPAMConfig;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.config.RestartPolicy;
import org.arquillian.cube.docker.impl.util.HomeResolverUtil;
import org.arquillian.cube.spi.CubeOutput;

public class DockerClientExecutor {
    private static final String DEFAULT_C_GROUPS_PERMISSION = "rwm";
    public static final String PATH_IN_CONTAINER = "pathInContainer";
    public static final String PATH_ON_HOST = "pathOnHost";
    public static final String C_GROUP_PERMISSIONS = "cGroupPermissions";
    public static final String PORTS_SEPARATOR = "->";
    public static final String TAG_SEPARATOR = ":";
    public static final String RESTART_POLICY = "restartPolicy";
    public static final String CAP_DROP = "capDrop";
    public static final String CAP_ADD = "capAdd";
    public static final String DEVICES = "devices";
    public static final String DNS_SEARCH = "dnsSearch";
    public static final String NETWORK_MODE = "networkMode";
    public static final String PUBLISH_ALL_PORTS = "publishAllPorts";
    public static final String PRIVILEGED = "privileged";
    public static final String PORT_BINDINGS = "portBindings";
    public static final String LINKS = "links";
    public static final String BINDS = "binds";
    public static final String VOLUMES_FROM = "volumesFrom";
    public static final String VOLUMES = "volumes";
    public static final String DNS = "dns";
    public static final String CMD = "cmd";
    public static final String ENV = "env";
    public static final String EXPOSED_PORTS = "exposedPorts";
    public static final String ATTACH_STDERR = "attachStderr";
    public static final String ATTACH_STDIN = "attachStdin";
    public static final String CPU_SHARES = "cpuShares";
    public static final String MEMORY_SWAP = "memorySwap";
    public static final String MEMORY_LIMIT = "memoryLimit";
    public static final String STDIN_ONCE = "stdinOnce";
    public static final String STDIN_OPEN = "stdinOpen";
    public static final String TTY = "tty";
    public static final String USER = "user";
    public static final String PORT_SPECS = "portSpecs";
    public static final String HOST_NAME = "hostName";
    public static final String DISABLE_NETWORK = "disableNetwork";
    public static final String WORKING_DIR = "workingDir";
    public static final String IMAGE = "image";
    public static final String BUILD_IMAGE = "buildImage";
    public static final String DOCKERFILE_LOCATION = "dockerfileLocation";
    public static final String NO_CACHE = "noCache";
    public static final String REMOVE = "remove";
    public static final String ALWAYS_PULL = "alwaysPull";
    public static final String ENTRYPOINT = "entryPoint";
    public static final String CPU_SET = "cpuSet";
    public static final String DOCKERFILE_NAME = "dockerfileName";
    public static final String EXTRA_HOSTS = "extraHosts";
    public static final String READ_ONLY_ROOT_FS = "ReadonlyRootfs";
    public static final String LABELS = "labels";
    public static final String DOMAINNAME = "domainName";
    private static final Logger log = Logger.getLogger(DockerClientExecutor.class.getName());
    private static final Pattern IMAGEID_PATTERN = Pattern.compile(".*Successfully built\\s(\\p{XDigit}+)");
    private DockerClient dockerClient;
    private CubeDockerConfiguration cubeConfiguration;
    private final URI dockerUri;
    private final String dockerServerIp;
    private DockerClientConfig dockerClientConfig;
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public DockerClientExecutor(CubeDockerConfiguration cubeConfiguration) {
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        String dockerServerUri = cubeConfiguration.getDockerServerUri();
        this.dockerUri = URI.create(dockerServerUri);
        this.dockerServerIp = cubeConfiguration.getDockerServerIp();
        configBuilder.withApiVersion(cubeConfiguration.getDockerServerVersion()).withDockerHost(this.dockerUri.toString());
        if (cubeConfiguration.getUsername() != null) {
            configBuilder.withRegistryUsername(cubeConfiguration.getUsername());
        }
        if (cubeConfiguration.getPassword() != null) {
            configBuilder.withRegistryPassword(cubeConfiguration.getPassword());
        }
        if (cubeConfiguration.getEmail() != null) {
            configBuilder.withRegistryEmail(cubeConfiguration.getEmail());
        }
        if (cubeConfiguration.getDockerRegistry() != null) {
            configBuilder.withRegistryUrl(cubeConfiguration.getDockerRegistry());
        }
        if (cubeConfiguration.getCertPath() != null) {
            configBuilder.withDockerCertPath(HomeResolverUtil.resolveHomeDirectoryChar(cubeConfiguration.getCertPath()));
        }
        configBuilder.withDockerTlsVerify(Boolean.valueOf(cubeConfiguration.getTlsVerify()));
        this.dockerClientConfig = configBuilder.build();
        this.cubeConfiguration = cubeConfiguration;
        this.dockerClient = this.buildDockerClient();
    }

    public DockerClient buildDockerClient() {
        return DockerClientBuilder.getInstance((DockerClientConfig)this.dockerClientConfig).build();
    }

    public List<Container> listRunningContainers() {
        this.readWriteLock.readLock().lock();
        try {
            List list = (List)this.dockerClient.listContainersCmd().exec();
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public String createContainer(String name, CubeContainer containerConfiguration) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> resolveDockerServerIpInList(Collection<String> envs) {
        ArrayList<String> resolvedEnv = new ArrayList<String>();
        for (String env : envs) {
            if (env.contains("dockerServerIp")) {
                resolvedEnv.add(env.replaceAll("dockerServerIp", this.cubeConfiguration.getDockerServerIp()));
                continue;
            }
            resolvedEnv.add(env);
        }
        return resolvedEnv;
    }

    private Set<ExposedPort> resolveExposedPorts(CubeContainer containerConfiguration, CreateContainerCmd createContainerCmd) {
        HashSet<ExposedPort> allExposedPorts = new HashSet<ExposedPort>();
        if (containerConfiguration.getPortBindings() != null) {
            for (PortBinding binding : containerConfiguration.getPortBindings()) {
                allExposedPorts.add(new ExposedPort(binding.getExposedPort().getExposed(), InternetProtocol.parse((String)binding.getExposedPort().getType())));
            }
        }
        if (containerConfiguration.getExposedPorts() != null) {
            for (org.arquillian.cube.docker.impl.client.config.ExposedPort port : containerConfiguration.getExposedPorts()) {
                allExposedPorts.add(new ExposedPort(port.getExposed(), InternetProtocol.parse((String)port.getType())));
            }
        }
        return allExposedPorts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getImageName(CubeContainer containerConfiguration, String name) {
        if (containerConfiguration.getImage() != null) {
            return containerConfiguration.getImage().toImageRef();
        }
        if (containerConfiguration.getBuildImage() == null) throw new IllegalArgumentException(String.format("Current configuration file does not contain %s nor %s parameter and one of both should be provided.", IMAGE, BUILD_IMAGE));
        BuildImage buildImage = containerConfiguration.getBuildImage();
        if (buildImage.getDockerfileLocation() == null) throw new IllegalArgumentException("A tar file with Dockerfile on root or a directory with a Dockerfile should be provided.");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(NO_CACHE, buildImage.isNoCache());
        params.put(REMOVE, buildImage.isRemove());
        params.put("dockerFileLocation", buildImage.getDockerfileLocation());
        params.put("dockerFileName", buildImage.getDockerfileName());
        return this.buildImage(buildImage.getDockerfileLocation(), name, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startContainer(String id, CubeContainer containerConfiguration) {
        this.readWriteLock.readLock().lock();
        try {
            StartContainerCmd startContainerCmd = this.dockerClient.startContainerCmd(id);
            startContainerCmd.exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics statsContainer(String id) throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            StatsCmd statsCmd = this.dockerClient.statsCmd(id);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            StatsLogsResultCallback statslogs = new StatsLogsResultCallback(countDownLatch);
            try {
                StatsLogsResultCallback statscallback = (StatsLogsResultCallback)statsCmd.exec((ResultCallback)statslogs);
                countDownLatch.await(5L, TimeUnit.SECONDS);
                statscallback.close();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            Statistics statistics = statslogs.getStatistics();
            return statistics;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private Ports toPortBindings(Collection<PortBinding> portBindings) {
        Ports ports = new Ports();
        for (PortBinding portBinding : portBindings) {
            ports.bind(new ExposedPort(portBinding.getExposedPort().getExposed(), InternetProtocol.parse((String)portBinding.getExposedPort().getType())), new Ports.Binding(portBinding.getHost(), Integer.toString(portBinding.getBound())));
        }
        return ports;
    }

    public void killContainer(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.killContainerCmd(containerId).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void stopContainer(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.stopContainerCmd(containerId).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void removeContainer(String containerId, boolean removeVolumes) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.removeContainerCmd(containerId).withRemoveVolumes(Boolean.valueOf(removeVolumes)).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public InspectContainerResponse inspectContainer(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            InspectContainerResponse inspectContainerResponse = this.dockerClient.inspectContainerCmd(containerId).exec();
            return inspectContainerResponse;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public int waitContainer(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            int n = ((WaitContainerResultCallback)this.dockerClient.waitContainerCmd(containerId).exec((ResultCallback)new WaitContainerResultCallback())).awaitStatusCode();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Version dockerHostVersion() {
        this.readWriteLock.readLock().lock();
        try {
            Version version = (Version)this.dockerClient.versionCmd().exec();
            return version;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void pingDockerServer() {
        this.readWriteLock.readLock().lock();
        try {
            try {
                PingCmd pingCmd = this.dockerClient.pingCmd();
                pingCmd.exec();
            }
            catch (ProcessingException e) {
                if (e.getCause() instanceof ConnectException) {
                    throw new IllegalStateException(String.format("Docker server is not running in %s host or it does not accept connections in tcp protocol, read https://github.com/arquillian/arquillian-cube#preliminaries to learn how to enable it.", this.cubeConfiguration.getDockerServerUri()), e);
                }
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildImage(String location, String name, Map<String, Object> params) {
        this.readWriteLock.writeLock().lock();
        try {
            String imageId;
            BuildImageCmd buildImageCmd = this.createBuildCommand(location);
            this.configureBuildCommand(params, buildImageCmd);
            if (name != null) {
                buildImageCmd.withTag(name);
            }
            if ((imageId = ((BuildImageResultCallback)buildImageCmd.exec((ResultCallback)new BuildImageResultCallback())).awaitImageId()) == null) {
                throw new IllegalStateException(String.format("Docker server has not provided an imageId for image build from %s.", location));
            }
            try {
                this.dockerClient.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.dockerClient = this.buildDockerClient();
            String string = imageId.trim();
            return string;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeImage(String contaierID, Boolean force) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.removeImageCmd(contaierID).withForce(force).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public static String getImageId(String fullLog) {
        Matcher m = IMAGEID_PATTERN.matcher(fullLog);
        String imageId = null;
        if (m.find()) {
            imageId = m.group(1);
        }
        return imageId;
    }

    private void configureBuildCommand(Map<String, Object> params, BuildImageCmd buildImageCmd) {
        if (params.containsKey(NO_CACHE)) {
            buildImageCmd.withNoCache(Boolean.valueOf((Boolean)params.get(NO_CACHE)));
        }
        if (params.containsKey(REMOVE)) {
            buildImageCmd.withRemove(Boolean.valueOf((Boolean)params.get(REMOVE)));
        }
        if (params.containsKey(DOCKERFILE_NAME)) {
            buildImageCmd.withDockerfile(new File((String)params.get(DOCKERFILE_NAME)));
        }
    }

    private BuildImageCmd createBuildCommand(String location) {
        BuildImageCmd buildImageCmd;
        block6: {
            buildImageCmd = null;
            try {
                URL url = new URL(location);
                buildImageCmd = this.dockerClient.buildImageCmd(url.openStream());
            }
            catch (MalformedURLException e) {
                File file = new File(location);
                if (!file.exists()) break block6;
                if (file.isDirectory()) {
                    buildImageCmd = this.dockerClient.buildImageCmd(file);
                }
                try {
                    buildImageCmd = this.dockerClient.buildImageCmd((InputStream)new FileInputStream(file));
                }
                catch (FileNotFoundException notFoundFile) {
                    throw new IllegalArgumentException(notFoundFile);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return buildImageCmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullImage(String imageName) {
        this.readWriteLock.readLock().lock();
        try {
            Image image = Image.valueOf(imageName);
            PullImageCmd pullImageCmd = this.dockerClient.pullImageCmd(image.getName());
            String tag = image.getTag();
            if (tag != null && !"".equals(tag)) {
                pullImageCmd.withTag(tag);
            } else {
                pullImageCmd.withTag("latest");
            }
            ((PullImageResultCallback)pullImageCmd.exec((ResultCallback)new PullImageResultCallback())).awaitSuccess();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CubeOutput execStart(String containerId, String ... commands) {
        this.readWriteLock.readLock().lock();
        try {
            String id = this.execCreate(containerId, commands);
            CubeOutput cubeOutput = this.execStartOutput(id);
            return cubeOutput;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execStartDetached(String containerId, String ... commands) {
        this.readWriteLock.readLock().lock();
        try {
            String id = this.execCreate(containerId, commands);
            this.dockerClient.execStartCmd(id).withDetach(Boolean.valueOf(true)).exec((ResultCallback)new ExecStartResultCallback());
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecInspection execStartVerbose(String containerId, String ... commands) {
        this.readWriteLock.readLock().lock();
        try {
            String id = this.execCreate(containerId, commands);
            CubeOutput output = this.execStartOutput(id);
            ExecInspection execInspection = new ExecInspection(output, this.inspectExec(id));
            return execInspection;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private InspectExecResponse inspectExec(String id) {
        InspectExecResponse exec = this.dockerClient.inspectExecCmd(id).exec();
        return exec;
    }

    private String execCreate(String containerId, String ... commands) {
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)this.dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(commands).exec();
        return execCreateCmdResponse.getId();
    }

    private CubeOutput execStartOutput(String id) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        try {
            ((ExecStartResultCallback)this.dockerClient.execStartCmd(id).withDetach(Boolean.valueOf(false)).exec((ResultCallback)new ExecStartResultCallback((OutputStream)outputStream, (OutputStream)errorStream))).awaitCompletion();
        }
        catch (InterruptedException e) {
            return new CubeOutput("", "");
        }
        return new CubeOutput(((Object)outputStream).toString(), ((Object)errorStream).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeLog> inspectChangesOnContainerFilesystem(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            List changeLogs = this.dockerClient.containerDiffCmd(containerId).exec();
            ArrayList<ChangeLog> changes = new ArrayList<ChangeLog>();
            for (com.github.dockerjava.api.model.ChangeLog changeLog : changeLogs) {
                changes.add(new ChangeLog(changeLog.getPath(), changeLog.getKind().intValue()));
            }
            ArrayList<ChangeLog> arrayList = changes;
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopContainer top(String containerId) {
        this.readWriteLock.readLock().lock();
        try {
            TopContainerResponse topContainer = this.dockerClient.topContainerCmd(containerId).exec();
            TopContainer topContainer2 = new TopContainer(topContainer.getTitles(), topContainer.getProcesses());
            return topContainer2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getFileOrDirectoryFromContainerAsTar(String containerId, String from) {
        this.readWriteLock.readLock().lock();
        try {
            InputStream response;
            InputStream inputStream = response = this.dockerClient.copyFileFromContainerCmd(containerId, from).exec();
            return inputStream;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void copyStreamToContainer(String containerId, File from) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.copyArchiveToContainerCmd(containerId).withHostResource(from.getAbsolutePath()).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStreamToContainer(String containerId, File from, File to) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.copyArchiveToContainerCmd(containerId).withRemotePath(to.getAbsolutePath()).withHostResource(from.getAbsolutePath()).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void connectToNetwork(String networkId, String containerID) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.connectToNetworkCmd().withNetworkId(networkId).withContainerId(containerID).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyLog(String containerId, boolean follow, boolean stdout, boolean stderr, boolean timestamps, int tail, OutputStream outputStream) throws IOException {
        this.readWriteLock.readLock().lock();
        try {
            LogContainerCmd logContainerCmd = this.dockerClient.logContainerCmd(containerId).withStdErr(Boolean.valueOf(false)).withStdOut(Boolean.valueOf(false));
            logContainerCmd.withFollowStream(Boolean.valueOf(follow));
            logContainerCmd.withStdOut(Boolean.valueOf(stdout));
            logContainerCmd.withStdErr(Boolean.valueOf(stderr));
            logContainerCmd.withTimestamps(Boolean.valueOf(timestamps));
            if (tail < 0) {
                logContainerCmd.withTailAll();
            } else {
                logContainerCmd.withTail(Integer.valueOf(tail));
            }
            OutputStreamLogsResultCallback outputStreamLogsResultCallback = new OutputStreamLogsResultCallback(outputStream);
            logContainerCmd.exec((ResultCallback)outputStreamLogsResultCallback);
            try {
                outputStreamLogsResultCallback.awaitCompletion();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private void readDockerRawStream(InputStream rawSteram, OutputStream outputStream) throws IOException {
        byte[] header = new byte[8];
        while (rawSteram.read(header) > 0) {
            ByteBuffer headerBuffer = ByteBuffer.wrap(header);
            byte type = headerBuffer.get();
            headerBuffer.get();
            headerBuffer.get();
            headerBuffer.get();
            int size = headerBuffer.getInt();
            byte[] streamOutputBuffer = new byte[size];
            rawSteram.read(streamOutputBuffer);
            outputStream.write(streamOutputBuffer);
        }
    }

    private String readDockerRawStreamToString(InputStream rawStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.readDockerRawStream(rawStream, output);
        return new String(output.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNetwork(String id, Network network) {
        this.readWriteLock.readLock().lock();
        try {
            CreateNetworkCmd createNetworkCmd = this.dockerClient.createNetworkCmd().withName(id);
            if (network.getDriver() != null) {
                createNetworkCmd.withDriver(network.getDriver());
            }
            if (network.getIpam() != null) {
                createNetworkCmd.withIpam(new Network.Ipam().withConfig(this.createIpamConfig(network)));
            }
            if (network.getOptions() != null && !network.getOptions().isEmpty()) {
                createNetworkCmd.withOptions(network.getOptions());
            }
            CreateNetworkResponse exec = (CreateNetworkResponse)createNetworkCmd.exec();
            String string = exec.getId();
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void removeNetwork(String id) {
        this.readWriteLock.readLock().lock();
        try {
            this.dockerClient.removeNetworkCmd(id).exec();
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private List<Network.Ipam.Config> createIpamConfig(Network network) {
        ArrayList<Network.Ipam.Config> ipamConfigs = new ArrayList<Network.Ipam.Config>();
        List<IPAMConfig> IPAMConfigs = network.getIpam().getIpamConfigs();
        if (IPAMConfigs != null) {
            for (IPAMConfig IpamConfig : IPAMConfigs) {
                Network.Ipam.Config config = new Network.Ipam.Config();
                if (IpamConfig.getGateway() != null) {
                    config.withGateway(IpamConfig.getGateway());
                }
                if (IpamConfig.getIpRange() != null) {
                    config.withIpRange(IpamConfig.getIpRange());
                }
                if (IpamConfig.getSubnet() != null) {
                    config.withSubnet(IpamConfig.getSubnet());
                }
                ipamConfigs.add(config);
            }
        }
        return ipamConfigs;
    }

    public URI getDockerUri() {
        return this.dockerUri;
    }

    private static final Device[] toDevices(Collection<org.arquillian.cube.docker.impl.client.config.Device> deviceList) {
        Device[] devices = new Device[deviceList.size()];
        int i = 0;
        for (org.arquillian.cube.docker.impl.client.config.Device device : deviceList) {
            if (device.getPathOnHost() == null || device.getPathInContainer() == null) continue;
            String cGroupPermissions = device.getcGroupPermissions() != null ? device.getcGroupPermissions() : DEFAULT_C_GROUPS_PERMISSION;
            String pathOnHost = device.getPathOnHost();
            String pathInContainer = device.getPathInContainer();
            devices[i] = new Device(cGroupPermissions, pathInContainer, pathOnHost);
            ++i;
        }
        return devices;
    }

    private static final com.github.dockerjava.api.model.RestartPolicy toRestartPolicy(RestartPolicy restart) {
        if (restart.getName() != null) {
            String name = restart.getName();
            if ("failure".equals(name)) {
                return com.github.dockerjava.api.model.RestartPolicy.onFailureRestart((int)restart.getMaximumRetryCount());
            }
            if ("restart".equals(name)) {
                return com.github.dockerjava.api.model.RestartPolicy.alwaysRestart();
            }
            return com.github.dockerjava.api.model.RestartPolicy.noRestart();
        }
        return com.github.dockerjava.api.model.RestartPolicy.noRestart();
    }

    private static final Link[] toLinks(Collection<org.arquillian.cube.docker.impl.client.config.Link> linkList) {
        Link[] links = new Link[linkList.size()];
        int i = 0;
        for (org.arquillian.cube.docker.impl.client.config.Link link : linkList) {
            links[i] = new Link(link.getName(), link.getAlias());
            ++i;
        }
        return links;
    }

    private static final Capability[] toCapability(Collection<String> configuredCapabilities) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (String capability : configuredCapabilities) {
            capabilities.add(Capability.valueOf((String)capability));
        }
        return capabilities.toArray(new Capability[capabilities.size()]);
    }

    private static final Bind[] toBinds(Collection<String> bindsList) {
        Bind[] binds = new Bind[bindsList.size()];
        int i = 0;
        for (String bind : bindsList) {
            binds[i] = Bind.parse((String)bind);
            ++i;
        }
        return binds;
    }

    private static final Volume[] toVolumes(Collection<String> volumesList) {
        Volume[] volumes = new Volume[volumesList.size()];
        int i = 0;
        for (String volume : volumesList) {
            volumes[i] = new Volume(volume);
            ++i;
        }
        return volumes;
    }

    private static final VolumesFrom[] toVolumesFrom(Collection<String> volumesFromList) {
        VolumesFrom[] volumesFrom = new VolumesFrom[volumesFromList.size()];
        int i = 0;
        for (String volumesFromm : volumesFromList) {
            volumesFrom[i] = VolumesFrom.parse((String)volumesFromm);
            ++i;
        }
        return volumesFrom;
    }

    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    public String getDockerServerIp() {
        return this.dockerServerIp;
    }

    private static class OutputStreamLogsResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        private OutputStream outputStream;

        public OutputStreamLogsResultCallback(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void onNext(Frame object) {
            try {
                this.outputStream.write(object.getPayload());
                this.outputStream.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ExecInspection {
        private CubeOutput output;
        private InspectExecResponse inspectExecResponse;

        public ExecInspection(CubeOutput output, InspectExecResponse inspectExecResponse) {
            this.output = output;
            this.inspectExecResponse = inspectExecResponse;
        }

        public CubeOutput getOutput() {
            return this.output;
        }

        public InspectExecResponse getInspectExecResponse() {
            return this.inspectExecResponse;
        }
    }
}

