/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Binding;

public final class BindingUtil {
    public static final String PORTS_SEPARATOR = "->";

    private BindingUtil() {
    }

    public static Binding binding(DockerClientExecutor executor, String cubeId) {
        Binding binding;
        block5: {
            InspectContainerResponse inspectResponse;
            block4: {
                inspectResponse = executor.getDockerClient().inspectContainerCmd(cubeId).exec();
                String dockerIp = BindingUtil.getDockerServerIp(executor);
                String inernalIp = null;
                NetworkSettings networkSettings = inspectResponse.getNetworkSettings();
                if (networkSettings != null) {
                    inernalIp = networkSettings.getIpAddress();
                }
                binding = new Binding(dockerIp, inernalIp);
                HostConfig hostConfig = inspectResponse.getHostConfig();
                if (hostConfig.getPortBindings() == null) break block4;
                for (Map.Entry bind : hostConfig.getPortBindings().getBindings().entrySet()) {
                    Ports.Binding[] allBindings;
                    for (Ports.Binding bindings : allBindings = (Ports.Binding[])bind.getValue()) {
                        binding.addPortBinding(Integer.valueOf(((ExposedPort)bind.getKey()).getPort()), Integer.valueOf(Integer.parseInt(bindings.getHostPortSpec())));
                    }
                }
                break block5;
            }
            ContainerConfig connectionConfig = inspectResponse.getConfig();
            ExposedPort[] exposedPorts = connectionConfig.getExposedPorts();
            if (exposedPorts == null) break block5;
            for (ExposedPort port : exposedPorts) {
                binding.addPortBinding(Integer.valueOf(port.getPort()), Integer.valueOf(-1));
            }
        }
        return binding;
    }

    private static String getDockerServerIp(DockerClientExecutor executor) {
        return executor.getDockerServerIp();
    }

    public static Binding binding(CubeContainer cubeConfiguration, DockerClientExecutor executor) {
        Binding binding = new Binding(executor.getDockerServerIp());
        if (cubeConfiguration.getPortBindings() != null) {
            for (PortBinding cubePortBinding : cubeConfiguration.getPortBindings()) {
                binding.addPortBinding(Integer.valueOf(cubePortBinding.getExposedPort().getExposed()), Integer.valueOf(cubePortBinding.getBound()));
            }
        }
        return binding;
    }
}

