/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectExecResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategyBase;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.docker.impl.util.PingCommand;
import org.arquillian.cube.spi.Cube;

public class DockerHealthAwaitStrategy
extends SleepingAwaitStrategyBase {
    private static final Logger log = Logger.getLogger(DockerHealthAwaitStrategy.class.getName());
    public static final String TAG = "docker_health";
    private static final int DEFAULT_POLL_ITERATIONS = 10;
    private int pollIterations;
    private Cube<?> cube;
    private DockerClient client;
    private String[] command;

    public DockerHealthAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        super(params.getSleepPollingTime());
        this.cube = cube;
        this.client = dockerClientExecutor.getDockerClient();
        this.pollIterations = this.getIterations(params);
        this.command = params.getCommand();
    }

    public boolean await() {
        PingCommand pingCommand = this.command != null ? new ExecPingCommand() : new DockerHealthPingCommand();
        return Ping.ping(this.pollIterations, this.getSleepTime(), this.getTimeUnit(), pingCommand);
    }

    private int getIterations(Await params) {
        if (params.getIterations() != null) {
            return params.getIterations();
        }
        return 10;
    }

    private class DockerHealthPingCommand
    implements PingCommand {
        private DockerHealthPingCommand() {
        }

        @Override
        public boolean call() {
            try {
                return DockerHealthAwaitStrategy.this.client.inspectContainerCmd(DockerHealthAwaitStrategy.this.cube.getId()).exec().getState().getHealth().getStatus().equals("healthy");
            }
            catch (NotFoundException e) {
                return false;
            }
        }
    }

    private class ExecPingCommand
    implements PingCommand {
        private ExecPingCommand() {
        }

        @Override
        public boolean call() {
            try {
                String execID = ((ExecCreateCmdResponse)DockerHealthAwaitStrategy.this.client.execCreateCmd(DockerHealthAwaitStrategy.this.cube.getId()).withCmd(DockerHealthAwaitStrategy.this.command).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).exec()).getId();
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                ByteArrayOutputStream stderr = new ByteArrayOutputStream();
                ExecStartResultCallback execStartResultCallback = new ExecStartResultCallback((OutputStream)stdout, (OutputStream)stderr);
                ((ExecStartResultCallback)DockerHealthAwaitStrategy.this.client.execStartCmd(DockerHealthAwaitStrategy.this.cube.getId()).withTty(Boolean.valueOf(true)).withExecId(execID).withDetach(Boolean.valueOf(false)).exec((ResultCallback)execStartResultCallback)).awaitCompletion();
                InspectExecResponse inspectExecResponse = DockerHealthAwaitStrategy.this.client.inspectExecCmd(execID).exec();
                log.info(() -> String.format("docker exec %s, exit status:%d, stdout:\n%s\n, stderr: \n%s\n", String.join((CharSequence)" ", DockerHealthAwaitStrategy.this.command), inspectExecResponse.getExitCode(), stdout.toString(), stderr.toString()));
                return inspectExecResponse.getExitCode() == 0;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }
}

