/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.arquillian.cube.ContainerObjectConfiguration;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.CubeIp;
import org.arquillian.cube.HostPort;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.containerobject.Environment;
import org.arquillian.cube.containerobject.Image;
import org.arquillian.cube.containerobject.Link;
import org.arquillian.cube.containerobject.Volume;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectConfiguration;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.impl.util.ContainerObjectUtil;
import org.arquillian.cube.docker.impl.util.DockerFileUtil;
import org.arquillian.cube.impl.client.enricher.CubeIpTestEnricher;
import org.arquillian.cube.impl.client.enricher.HostPortTestEnricher;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;

public class DockerContainerObjectBuilder<T> {
    public static final String TEMPORARY_FOLDER_PREFIX = "arquilliancube_";
    public static final String TEMPORARY_FOLDER_SUFFIX = ".build";
    private static final Logger logger = Logger.getLogger(DockerContainerObjectBuilder.class.getName());
    private final DockerClientExecutor dockerClientExecutor;
    private final CubeController cubeController;
    private final CubeRegistry cubeRegistry;
    private Class<T> containerObjectClass;
    private Object containerObjectContainer;
    private CubeContainer providedConfiguration;
    private Collection<TestEnricher> enrichers = Collections.emptyList();
    private Consumer<DockerCube> cubeCreatedCallback;
    private boolean classHasMethodWithCubeDockerFile;
    private boolean classDefinesCubeDockerFile;
    private boolean classDefinesImage;
    private Method methodWithCubeDockerFile;
    private CubeDockerFile cubeDockerFileAnnotation;
    private Image cubeImageAnnotation;
    private String containerName;
    private File dockerfileLocation;
    private CubeContainer generatedConfigutation;
    private CubeContainer mergedConfiguration;
    private T containerObjectInstance;
    private DockerCube dockerCube;

    public DockerContainerObjectBuilder(DockerClientExecutor dockerClientExecutor, CubeController cubeController, CubeRegistry cubeRegistry) {
        this.dockerClientExecutor = dockerClientExecutor;
        this.cubeController = cubeController;
        this.cubeRegistry = cubeRegistry;
    }

    private static String findEnrichedValueForFieldWithCubeIpAnnotation(CubeIp cubeIp, HasPortBindings portBindings) {
        boolean cubeIpInternal = cubeIp.internal();
        String cubeIpValue = cubeIpInternal ? portBindings.getInternalIP() : portBindings.getContainerIP();
        return cubeIpValue;
    }

    private static int findEnrichedValueForFieldWithHostPortAnnotation(HostPort hostPort, HasPortBindings portBindings) {
        int hostPortValue = hostPort.value();
        if (hostPortValue == 0) {
            throw new IllegalArgumentException(String.format("%s annotation does not specify any exposed port", HostPort.class.getSimpleName()));
        }
        HasPortBindings.PortAddress bindingForExposedPort = portBindings.getMappedAddress(hostPortValue);
        if (bindingForExposedPort == null) {
            throw new IllegalArgumentException(String.format("exposed port %s is not exposed on container object.", hostPortValue));
        }
        return bindingForExposedPort.getPort();
    }

    private static File createTemporalDirectoryForCopyingDockerfile(String containerName) throws IOException {
        File dir = File.createTempFile(TEMPORARY_FOLDER_PREFIX + containerName, TEMPORARY_FOLDER_SUFFIX);
        dir.delete();
        if (!dir.mkdirs()) {
            throw new IllegalArgumentException("Temp Dir for storing Dockerfile contents could not be created.");
        }
        dir.deleteOnExit();
        return dir;
    }

    private static org.arquillian.cube.docker.impl.client.config.Link linkFromCubeAnnotatedField(Field cubeField) {
        String linkName = DockerContainerObjectBuilder.linkNameFromCubeAnnotatedField(cubeField);
        return org.arquillian.cube.docker.impl.client.config.Link.valueOf(linkName);
    }

    private static String linkNameFromCubeAnnotatedField(Field cubeField) {
        if (cubeField.isAnnotationPresent(Link.class)) {
            return cubeField.getAnnotation(Link.class).value();
        }
        String cubeName = DockerContainerObjectBuilder.cubeNameFromCubeAnnotatedField(cubeField);
        return cubeName + ":" + cubeName;
    }

    private static String cubeNameFromCubeAnnotatedField(Field cubeField) {
        Cube cubeAnnotationOnField = cubeField.getAnnotation(Cube.class);
        Class<?> containerObjectClassFromField = cubeField.getType();
        Object cubeName = null;
        String cubeAnnotationOnFieldValue = cubeAnnotationOnField.value();
        if (cubeAnnotationOnFieldValue != null && !"".equals(cubeAnnotationOnFieldValue)) {
            return cubeAnnotationOnFieldValue;
        }
        String cubeAnnotationOnClassValue = ContainerObjectUtil.getTopCubeAttribute(containerObjectClassFromField, "value", Cube.class, "");
        if (cubeAnnotationOnClassValue != null && !"".equals(cubeAnnotationOnClassValue)) {
            return cubeAnnotationOnClassValue;
        }
        return containerObjectClassFromField.getSimpleName();
    }

    public DockerContainerObjectBuilder<T> withContainerObjectContainer(Object containerObjectContainer) {
        this.containerObjectContainer = containerObjectContainer;
        return this;
    }

    public DockerContainerObjectBuilder<T> withContainerObjectClass(Class<T> containerObjectClass) {
        if (containerObjectClass == null) {
            throw new IllegalArgumentException("container object class cannot be null");
        }
        this.containerObjectClass = containerObjectClass;
        List methodsWithCubeDockerFile = ReflectionUtil.getMethodsWithAnnotation(containerObjectClass, CubeDockerFile.class);
        if (methodsWithCubeDockerFile.size() > 1) {
            throw new IllegalArgumentException(String.format("More than one %s annotation found and only one was expected. Methods where annotation was found are: %s", CubeDockerFile.class.getSimpleName(), methodsWithCubeDockerFile));
        }
        this.classHasMethodWithCubeDockerFile = !methodsWithCubeDockerFile.isEmpty();
        this.classDefinesCubeDockerFile = containerObjectClass.isAnnotationPresent(CubeDockerFile.class);
        this.classDefinesImage = containerObjectClass.isAnnotationPresent(Image.class);
        if (this.classHasMethodWithCubeDockerFile) {
            this.methodWithCubeDockerFile = (Method)methodsWithCubeDockerFile.get(0);
            boolean isMethodStatic = Modifier.isStatic(this.methodWithCubeDockerFile.getModifiers());
            boolean methodHasNoArguments = this.methodWithCubeDockerFile.getParameterCount() == 0;
            boolean methodReturnsAnArchive = Archive.class.isAssignableFrom(this.methodWithCubeDockerFile.getReturnType());
            if (!(isMethodStatic && methodHasNoArguments && methodReturnsAnArchive)) {
                throw new IllegalArgumentException(String.format("Method %s annotated with %s is expected to be static, no args and return %s.", this.methodWithCubeDockerFile, CubeDockerFile.class.getSimpleName(), Archive.class.getSimpleName()));
            }
        }
        if (this.classHasMethodWithCubeDockerFile && this.classDefinesCubeDockerFile) {
            throw new IllegalArgumentException(String.format("More than one %s annotation found and only one was expected. Both class and method %s has the annotation.", CubeDockerFile.class.getSimpleName(), this.methodWithCubeDockerFile));
        }
        if ((this.classHasMethodWithCubeDockerFile || this.classDefinesCubeDockerFile) && this.classDefinesImage) {
            throw new IllegalArgumentException(String.format("Container Object %s has defined %s annotation and %s annotation together.", containerObjectClass.getSimpleName(), Image.class.getSimpleName(), CubeDockerFile.class.getSimpleName()));
        }
        if (!(this.classDefinesCubeDockerFile || this.classDefinesImage || this.classHasMethodWithCubeDockerFile)) {
            throw new IllegalArgumentException(String.format("Container Object %s is not annotated with either %s or %s annotations.", containerObjectClass.getName(), CubeDockerFile.class.getSimpleName(), Image.class.getSimpleName()));
        }
        return this;
    }

    public DockerContainerObjectBuilder<T> withContainerObjectConfiguration(ContainerObjectConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        if (configuration != null && !(configuration instanceof CubeContainerObjectConfiguration)) {
            throw new IllegalArgumentException(String.format("container object configuration received of type %s, but only %s is supported", configuration.getClass().getSimpleName(), CubeContainerObjectConfiguration.class.getSimpleName()));
        }
        this.providedConfiguration = configuration != null ? ((CubeContainerObjectConfiguration)configuration).getCubeContainerConfiguration() : null;
        return this;
    }

    public DockerContainerObjectBuilder<T> withEnrichers(Collection<TestEnricher> enrichers) {
        if (enrichers == null) {
            throw new IllegalArgumentException("enrichers cannot be null");
        }
        this.enrichers = enrichers;
        return this;
    }

    public DockerContainerObjectBuilder<T> onCubeCreated(Consumer<DockerCube> cubeCreatedCallback) {
        this.cubeCreatedCallback = cubeCreatedCallback;
        return this;
    }

    public T build() throws IllegalAccessException, IOException, InvocationTargetException {
        this.generatedConfigutation = new CubeContainer();
        this.findContainerName();
        this.prepareImageBuild();
        this.instantiateContainerObject();
        this.enrichContainerObjectBeforeCube();
        this.extractConfigurationFromContainerObject();
        this.mergeContainerObjectConfiguration();
        this.initializeCube();
        this.enrichContainerObjectWithCube();
        return this.containerObjectInstance;
    }

    private void findContainerName() {
        String cubeValue;
        String providedContainerName;
        if (this.providedConfiguration != null && (providedContainerName = this.providedConfiguration.getContainerName()) != null && !providedContainerName.isEmpty()) {
            this.containerName = this.providedConfiguration.getContainerName();
        }
        if (this.containerName == null && (cubeValue = ContainerObjectUtil.getTopCubeAttribute(this.containerObjectClass, "value", Cube.class, "")) != null && !"".equals(cubeValue)) {
            this.containerName = cubeValue;
        }
        if (this.containerName == null) {
            this.containerName = this.containerObjectClass.getSimpleName();
        }
        this.generatedConfigutation.setContainerName(this.containerName);
    }

    private void prepareImageBuild() throws InvocationTargetException, IllegalAccessException, IOException {
        if (this.classHasMethodWithCubeDockerFile) {
            this.cubeDockerFileAnnotation = this.methodWithCubeDockerFile.getAnnotation(CubeDockerFile.class);
            Archive archive = (Archive)this.methodWithCubeDockerFile.invoke(null, new Object[0]);
            File output = DockerContainerObjectBuilder.createTemporalDirectoryForCopyingDockerfile(this.containerName);
            logger.finer(String.format("Created %s directory for storing contents of %s cube.", output, this.containerName));
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(output);
            this.dockerfileLocation = output;
        } else if (this.classDefinesCubeDockerFile) {
            this.cubeDockerFileAnnotation = this.containerObjectClass.getAnnotation(CubeDockerFile.class);
            File output = DockerContainerObjectBuilder.createTemporalDirectoryForCopyingDockerfile(this.containerName);
            logger.finer(String.format("Created %s directory for storing contents of %s cube.", output, this.containerName));
            DockerFileUtil.copyDockerfileDirectory(this.containerObjectClass, this.cubeDockerFileAnnotation, output);
            this.dockerfileLocation = output;
        } else if (this.classDefinesImage) {
            this.cubeImageAnnotation = this.containerObjectClass.getAnnotation(Image.class);
        }
    }

    private void instantiateContainerObject() {
        this.containerObjectInstance = ReflectionUtil.newInstance((String)this.containerObjectClass.getName(), (Class[])new Class[0], (Object[])new Class[0], this.containerObjectClass);
    }

    private void enrichContainerObjectBeforeCube() {
        for (TestEnricher enricher : this.enrichers) {
            boolean requiresDockerInstanceCreated = enricher instanceof HostPortTestEnricher || enricher instanceof CubeIpTestEnricher;
            if (requiresDockerInstanceCreated) continue;
            enricher.enrich(this.containerObjectInstance);
        }
    }

    private void extractConfigurationFromContainerObject() {
        int[] awaitPortsFromAnnotation;
        Object[] portBindingsFromAnnotation;
        if (!(this.providedConfiguration != null && this.providedConfiguration.getPortBindings() != null || (portBindingsFromAnnotation = ContainerObjectUtil.getTopCubeAttribute(this.containerObjectClass, "portBinding", Cube.class, Cube.DEFAULT_PORT_BINDING)) == null || Arrays.equals(portBindingsFromAnnotation, Cube.DEFAULT_PORT_BINDING))) {
            List<PortBinding> portBindings = Arrays.stream(portBindingsFromAnnotation).map(PortBinding::valueOf).collect(Collectors.toList());
            this.generatedConfigutation.setPortBindings(portBindings);
        }
        if (!(this.providedConfiguration != null && this.providedConfiguration.getAwait() != null || (awaitPortsFromAnnotation = ContainerObjectUtil.getTopCubeAttribute(this.containerObjectClass, "awaitPorts", Cube.class, Cube.DEFAULT_AWAIT_PORT_BINDING)) == null || Arrays.equals(awaitPortsFromAnnotation, Cube.DEFAULT_AWAIT_PORT_BINDING))) {
            Await await = new Await();
            await.setStrategy("polling");
            await.setPorts(Arrays.asList(ArrayUtils.toObject((int[])awaitPortsFromAnnotation)));
            this.generatedConfigutation.setAwait(await);
        }
        List<String> environmentVariables = ContainerObjectUtil.getAllAnnotations(this.containerObjectClass, Environment.class).stream().map(environment -> environment.key() + "=" + environment.value()).collect(Collectors.toList());
        this.generatedConfigutation.setEnv(environmentVariables);
        List<String> volumeBindings = ContainerObjectUtil.getAllAnnotations(this.containerObjectClass, Volume.class).stream().map(volume -> volume.hostPath() + ":" + volume.containerPath() + ":Z").collect(Collectors.toList());
        this.generatedConfigutation.setBinds(volumeBindings);
        if (this.providedConfiguration == null || this.providedConfiguration.getLinks() == null) {
            List<org.arquillian.cube.docker.impl.client.config.Link> links = ReflectionUtil.getFieldsWithAnnotation(this.containerObjectClass, Cube.class).stream().map(DockerContainerObjectBuilder::linkFromCubeAnnotatedField).collect(Collectors.toList());
            this.generatedConfigutation.setLinks(links);
        }
        if (this.classDefinesCubeDockerFile || this.classHasMethodWithCubeDockerFile) {
            BuildImage dockerfileConfiguration = new BuildImage(this.dockerfileLocation.getAbsolutePath(), null, this.cubeDockerFileAnnotation.nocache(), this.cubeDockerFileAnnotation.remove());
            this.generatedConfigutation.setBuildImage(dockerfileConfiguration);
        } else {
            this.generatedConfigutation.setImage(org.arquillian.cube.docker.impl.client.config.Image.valueOf(this.cubeImageAnnotation.value()));
        }
    }

    private void mergeContainerObjectConfiguration() {
        this.mergedConfiguration = new CubeContainer();
        if (this.providedConfiguration != null) {
            this.mergedConfiguration.merge(this.providedConfiguration);
        }
        this.mergedConfiguration.merge(this.generatedConfigutation);
        if (this.providedConfiguration != null) {
            if (this.providedConfiguration.getEnv() != null && this.generatedConfigutation.getEnv() != null) {
                ArrayList<String> env = new ArrayList<String>();
                env.addAll(this.mergedConfiguration.getEnv());
                env.addAll(this.generatedConfigutation.getEnv());
                this.mergedConfiguration.setEnv(env);
            }
            if (this.providedConfiguration.getBinds() != null && this.generatedConfigutation.getBinds() != null) {
                ArrayList<String> binds = new ArrayList<String>();
                binds.addAll(this.mergedConfiguration.getBinds());
                binds.addAll(this.generatedConfigutation.getBinds());
                this.mergedConfiguration.setBinds(binds);
            }
        }
    }

    private void initializeCube() {
        if (this.isNotInitialized()) {
            this.dockerCube = new DockerCube(this.containerName, this.mergedConfiguration, this.dockerClientExecutor);
            Class<?> containerObjectContainerClass = this.containerObjectContainer != null ? this.containerObjectContainer.getClass() : null;
            this.dockerCube.addMetadata(IsContainerObject.class, (CubeMetadata)new IsContainerObject(containerObjectContainerClass));
            logger.finer(String.format("Created Cube with name %s and configuration %s", this.containerName, this.dockerCube.configuration()));
            if (this.cubeCreatedCallback != null) {
                this.cubeCreatedCallback.accept(this.dockerCube);
            }
            this.cubeController.create(this.containerName);
            this.cubeController.start(this.containerName);
        }
    }

    private boolean isNotInitialized() {
        return this.cubeRegistry.getCube(this.containerName) == null;
    }

    private void enrichContainerObjectWithCube() throws IllegalAccessException {
        this.enrichAnnotatedPortBuildingFields(CubeIp.class, DockerContainerObjectBuilder::findEnrichedValueForFieldWithCubeIpAnnotation);
        this.enrichAnnotatedPortBuildingFields(HostPort.class, DockerContainerObjectBuilder::findEnrichedValueForFieldWithHostPortAnnotation);
    }

    private <T extends Annotation> void enrichAnnotatedPortBuildingFields(Class<T> annotationType, BiFunction<T, HasPortBindings, ?> fieldEnricher) throws IllegalAccessException {
        List annotatedFields = ReflectionUtil.getFieldsWithAnnotation(this.containerObjectClass, annotationType);
        if (annotatedFields.isEmpty()) {
            return;
        }
        HasPortBindings portBindings = (HasPortBindings)this.dockerCube.getMetadata(HasPortBindings.class);
        if (portBindings == null) {
            throw new IllegalArgumentException(String.format("Container Object %s contains fields annotated with %s but no ports are exposed by the container", this.containerObjectClass.getSimpleName(), annotationType.getSimpleName()));
        }
        for (Field annotatedField : annotatedFields) {
            T annotation = annotatedField.getAnnotation(annotationType);
            try {
                annotatedField.set(this.containerObjectInstance, fieldEnricher.apply(annotation, portBindings));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(String.format("Container Object %s contains field %s annotated with %s, with error: %s", this.containerObjectClass.getSimpleName(), annotatedField.getName(), annotationType.getSimpleName(), ex.getLocalizedMessage()), ex);
            }
        }
    }
}

