/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.model.Info;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.DefaultDocker;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.GitHubUtil;
import org.arquillian.cube.docker.impl.util.HomeResolverUtil;
import org.arquillian.cube.docker.impl.util.Machine;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemInterface;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.net.DownloadTool;

public class CubeDockerConfigurationResolver {
    private static final String UNIX_SOCKET_SCHEME = "unix";
    private static final String TCP_SCHEME = "tcp";
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    private static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    private static final String DOCKER_MACHINE_NAME = "DOCKER_MACHINE_NAME";
    private static Random random = new Random();
    private static Logger log = Logger.getLogger(CubeDockerConfigurationResolver.class.getName());
    private final Top top;
    private final DockerMachine dockerMachine;
    private final Boot2Docker boot2Docker;
    private final DefaultDocker defaultDocker;
    private final OperatingSystemInterface operatingSystem;

    public CubeDockerConfigurationResolver(Top top, DockerMachine dockerMachine, Boot2Docker boot2Docker, DefaultDocker defaultDocker, OperatingSystemInterface operatingSystem) {
        this.top = top;
        this.dockerMachine = dockerMachine;
        this.boot2Docker = boot2Docker;
        this.operatingSystem = operatingSystem;
        this.defaultDocker = defaultDocker;
    }

    public Map<String, String> resolve(Map<String, String> config) {
        config = this.resolveSystemEnvironmentVariables(config);
        config = this.resolveSystemDefaultSetup(config);
        config = this.resolveDockerInsideDocker(config);
        config = this.resolveDownloadDockerMachine(config);
        config = this.resolveAutoStartDockerMachine(config);
        config = this.resolveDefaultDockerMachine(config);
        config = this.resolveServerUriByOperativeSystem(config);
        config = this.resolveServerIp(config);
        config = this.resolveTlsVerification(config);
        return config;
    }

    private Map<String, String> resolveDockerInsideDocker(Map<String, String> cubeConfiguration) {
        if ((!cubeConfiguration.containsKey("dockerInsideDockerResolution") || Boolean.parseBoolean(cubeConfiguration.get("dockerInsideDockerResolution"))) && this.top.isSpinning()) {
            log.fine(String.format("Your Cube tests are going to run inside a running Docker container. %s property is replaced to %s", "serverUri", OperatingSystemFamily.DIND.getServerUri()));
            String serverUri = OperatingSystemFamily.DIND.getServerUri();
            cubeConfiguration.put("serverUri", serverUri);
        }
        return cubeConfiguration;
    }

    private Map<String, String> resolveDownloadDockerMachine(Map<String, String> config) {
        String cliPathExec;
        if (config.containsKey("machineName") && !this.dockerMachine.isDockerMachineInstalled(cliPathExec = config.get("dockerMachinePath"))) {
            String machineVersion = GitHubUtil.getDockerMachineLatestVersion();
            String machineCustomPath = config.get("dockerMachineCustomPath");
            File dockerMachineFile = CubeDockerConfiguration.resolveMachinePath(machineCustomPath, machineVersion);
            String dockerMachinePath = dockerMachineFile.getPath();
            boolean dockerMachineFileExist = dockerMachineFile != null && dockerMachineFile.exists();
            String machineName = config.get("machineName");
            String machineUrl = CubeDockerConfiguration.resolveUrl(machineVersion);
            if (!dockerMachineFileExist) {
                dockerMachineFile.getParentFile().mkdirs();
                ((DownloadTool)Spacelift.task(DownloadTool.class)).from(machineUrl).to(dockerMachineFile).execute().await();
                config.put("dockerMachinePath", dockerMachinePath);
                this.dockerMachine.grantPermissionToDockerMachine(dockerMachinePath);
                String machineDriver = config.get("machineDriver");
                this.dockerMachine.createMachine(dockerMachinePath, machineDriver, machineName);
            } else {
                config.put("dockerMachinePath", dockerMachinePath);
            }
        }
        return config;
    }

    private Map<String, String> resolveAutoStartDockerMachine(Map<String, String> config) {
        String cliPathExec = config.get("dockerMachinePath");
        if (this.dockerMachine.isDockerMachineInstalled(cliPathExec)) {
            Set<Machine> allMachines = this.dockerMachine.list(cliPathExec);
            Optional<Machine> machine = Optional.empty();
            if (config.containsKey("machineName")) {
                String configuredMachineName = config.get("machineName");
                machine = allMachines.stream().filter(m -> configuredMachineName.equals(m.getName())).filter(m -> "Stopped".equalsIgnoreCase(m.getState())).findFirst();
            } else if (allMachines.size() == 1 && "Stopped".equalsIgnoreCase(allMachines.iterator().next().getState())) {
                machine = Optional.of(allMachines.iterator().next());
            }
            machine.ifPresent(m -> this.dockerMachine.startDockerMachine(cliPathExec, m.getName()));
        }
        return config;
    }

    private Map<String, String> resolveDefaultDockerMachine(Map<String, String> config) {
        if (!config.containsKey("serverUri") && !config.containsKey("machineName")) {
            Set<Machine> machines;
            log.fine("No DockerUri or DockerMachine has been set, let's see if there is only one Docker Machine Running.");
            if (this.dockerMachine.isDockerMachineInstalled(config.get("dockerMachinePath")) && (machines = this.dockerMachine.list(config.get("dockerMachinePath"), "state", "Running")).size() == 1) {
                log.fine(String.format("One Docker Machine is running (%s) and it is going to be used for tests", machines.iterator().next().getName()));
                config.put("machineName", this.getFirstMachine(machines).getName());
            }
        }
        return config;
    }

    private Machine getFirstMachine(Set<Machine> machines) {
        return machines.iterator().next();
    }

    private Map<String, String> resolveSystemEnvironmentVariables(Map<String, String> config) {
        if (!config.containsKey("serverUri") && this.isDockerHostSet()) {
            String dockerHostUri = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"DOCKER_HOST");
            config.put("serverUri", dockerHostUri);
        }
        if (!config.containsKey("certPath") && this.isDockerCertPathSet()) {
            String dockerCertPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH);
            config.put("certPath", dockerCertPath);
        }
        if (!config.containsKey("machineName") && this.isDockerMachineNameSet()) {
            String dockerMachineName = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME);
            config.put("machineName", dockerMachineName);
        }
        if (!config.containsKey("tlsVerify") && this.isDockerTlsVerifySet()) {
            config.put("tlsVerify", Boolean.TRUE.toString());
        }
        return config;
    }

    private Map<String, String> resolveSystemDefaultSetup(Map<String, String> config) {
        if (!config.containsKey("serverUri")) {
            String defaultUri = this.operatingSystem.getDefaultFamily().getServerUri();
            URI uri = URI.create(defaultUri);
            if (Files.exists(FileSystems.getDefault().getPath(uri.getPath(), new String[0]), new LinkOption[0])) {
                DockerClient client = this.defaultDocker.getDefaultDockerClient(defaultUri);
                InfoCmd cmd = client.infoCmd();
                try {
                    Info info = (Info)cmd.exec();
                    config.put("serverUri", defaultUri);
                    log.info(String.format("Connected to docker (%s) using default settings version: %s kernel: %s", info.getName(), info.getServerVersion(), info.getKernelVersion()));
                }
                catch (ProcessingException e) {
                    log.info(String.format("Could not connect to default socket %s. Go on with ", this.operatingSystem.getDefaultFamily().getServerUri()));
                }
            }
        }
        return config;
    }

    private Map<String, String> resolveServerIp(Map<String, String> config) {
        String dockerServerUri = config.get("serverUri");
        if (this.containsDockerHostTag(dockerServerUri)) {
            dockerServerUri = this.isDockerMachineSet(config) ? this.resolveDockerMachine(dockerServerUri, config.get("machineName"), config.get("dockerMachinePath")) : this.resolveBoot2Docker(dockerServerUri, config.get("boot2dockerPath"));
            if (!config.containsKey("tlsVerify")) {
                config.put("tlsVerify", Boolean.toString(true));
            }
        }
        config.put("serverUri", dockerServerUri);
        this.resolveDockerServerIp(config, dockerServerUri);
        return config;
    }

    private Map<String, String> resolveTlsVerification(Map<String, String> config) {
        URI serverUri = URI.create(config.get("serverUri"));
        String scheme = serverUri.getScheme();
        if (!config.containsKey("certPath")) {
            config.put("certPath", HomeResolverUtil.resolveHomeDirectoryChar(this.getDefaultTlsDirectory(config)));
        }
        if (scheme.equals(HTTP_SCHEME)) {
            config.remove("tlsVerify");
        }
        if (scheme.equals(HTTPS_SCHEME)) {
            config.put("tlsVerify", Boolean.toString(true));
        }
        if (scheme.equals(HTTP_SCHEME) || scheme.equals(HTTPS_SCHEME) || scheme.equals(TCP_SCHEME)) {
            if (!config.containsKey("tlsVerify")) {
                config.put("tlsVerify", Boolean.toString(scheme.equals(HTTPS_SCHEME)));
            }
            try {
                serverUri = new URI(TCP_SCHEME, serverUri.getSchemeSpecificPart(), serverUri.getFragment());
                config.put("serverUri", serverUri.toString());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (scheme.equals(UNIX_SOCKET_SCHEME) || scheme.equals("npipe")) {
            config.put("tlsVerify", Boolean.toString(false));
        }
        if (!config.containsKey("tlsVerify")) {
            config.put("tlsVerify", Boolean.toString(true));
            if (this.operatingSystem.getFamily() == OperatingSystemFamily.LINUX) {
                String dockerServerIp = config.get("dockerServerIp");
                if (this.isDockerMachineSet(config)) {
                    if (InetAddress.getLoopbackAddress().getHostAddress().equals(dockerServerIp) || InetAddress.getLoopbackAddress().getHostName().equals(dockerServerIp)) {
                        config.put("tlsVerify", Boolean.toString(false));
                    } else {
                        config.put("tlsVerify", Boolean.toString(true));
                    }
                } else {
                    config.put("tlsVerify", Boolean.toString(false));
                }
            }
        }
        if (Boolean.FALSE.toString().equals(config.get("tlsVerify"))) {
            config.remove("certPath");
        }
        return config;
    }

    private boolean containsDockerHostTag(String dockerServerUri) {
        return dockerServerUri.contains("dockerHost");
    }

    private void resolveDockerServerIp(Map<String, String> config, String dockerServerUri) {
        URI serverUri = URI.create(dockerServerUri);
        String serverIp = UNIX_SOCKET_SCHEME.equalsIgnoreCase(serverUri.getScheme()) ? "localhost" : serverUri.getHost();
        config.put("dockerServerIp", serverIp);
    }

    private boolean isDockerHostSet() {
        return Strings.isNotNullOrEmpty((String)SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"DOCKER_HOST"));
    }

    private boolean isDockerCertPathSet() {
        return Strings.isNotNullOrEmpty((String)SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_CERT_PATH));
    }

    private boolean isDockerTlsVerifySet() {
        return Strings.isNotNullOrEmpty((String)SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_TLS_VERIFY));
    }

    private boolean isDockerMachineNameSet() {
        return Strings.isNotNullOrEmpty((String)SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)DOCKER_MACHINE_NAME));
    }

    private boolean isDockerMachineSet(Map<String, String> config) {
        return config.containsKey("machineName");
    }

    private String resolveDockerMachine(String tag, String machineName, String dockerMachinePath) {
        this.dockerMachine.setMachineName(machineName);
        return tag.replaceAll("dockerHost", this.dockerMachine.ip(dockerMachinePath, false));
    }

    private String resolveBoot2Docker(String tag, String boot2DockerPath) {
        return tag.replaceAll("dockerHost", this.boot2Docker.ip(boot2DockerPath, false));
    }

    private String getDefaultTlsDirectory(Map<String, String> config) {
        if (this.isDockerMachineSet(config)) {
            return "~" + File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + config.get("machineName");
        }
        return "~" + File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm";
    }

    private boolean containsCertPath(Map<String, String> cubeConfiguration) {
        return cubeConfiguration.containsKey("certPath");
    }

    private Map<String, String> resolveServerUriByOperativeSystem(Map<String, String> cubeConfiguration) {
        if (!cubeConfiguration.containsKey("serverUri")) {
            if (this.isDockerMachineSet(cubeConfiguration)) {
                String serverUri = OperatingSystemFamily.MACHINE.getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            } else {
                String serverUri = this.operatingSystem.getFamily().getServerUri();
                cubeConfiguration.put("serverUri", serverUri);
            }
        }
        return cubeConfiguration;
    }
}

