/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategyBase;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.Ping;
import org.arquillian.cube.impl.util.IOUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeOutput;
import org.arquillian.cube.spi.metadata.HasPortBindings;

public class PollingAwaitStrategy
extends SleepingAwaitStrategyBase {
    public static final String TAG = "polling";
    public static final String CONTAINER_DIRECTORY = "/tmp";
    private static final Logger log = Logger.getLogger(PollingAwaitStrategy.class.getName());
    private static final String MESSAGE = "Service is Up";
    private static final String WAIT_FOR_IT_SCRIPT = "wait-for-it.sh";
    private static final int DEFAULT_POLL_ITERATIONS = 80;
    private static final String DEFAULT_POLL_TYPE = "sscommand";
    private int pollIterations = 80;
    private String type = "sscommand";
    private DockerClientExecutor dockerClientExecutor;
    private Cube<?> cube;
    private List<Integer> ports = null;
    private boolean alreadyCopiedWaitForIt = false;

    public PollingAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        super(params.getSleepPollingTime());
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        if (params.getIterations() != null) {
            this.pollIterations = params.getIterations();
        }
        if (params.getType() != null) {
            this.type = params.getType();
        }
        if (params.getPorts() != null && params.getPorts().size() > 0) {
            this.ports = params.getPorts();
        }
    }

    public int getPollIterations() {
        return this.pollIterations;
    }

    public String getType() {
        return this.type;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public boolean await() {
        HasPortBindings portBindings = (HasPortBindings)this.cube.getMetadata(HasPortBindings.class);
        if (portBindings == null) {
            log.fine("Cube does not have any ports to ping.");
            return true;
        }
        Collection<Integer> pingPorts = this.ports;
        if (this.ports == null) {
            pingPorts = portBindings.getBoundPorts();
        }
        block14: for (Integer port : pingPorts) {
            switch (this.type) {
                case "ping": {
                    HasPortBindings.PortAddress mapping = portBindings.getMappedAddress(port.intValue());
                    if (mapping == null) {
                        throw new IllegalArgumentException("Can not use polling of type " + this.type + " on non externally bound port " + port);
                    }
                    log.fine(String.format("Pinging host %s and port %s with type", mapping.getIP(), mapping.getPort(), this.type));
                    if (Ping.ping(mapping.getIP(), mapping.getPort(), this.pollIterations, this.getSleepTime(), this.getTimeUnit())) continue block14;
                    return false;
                }
                case "sscommand": {
                    try {
                        if (Ping.ping(this.dockerClientExecutor, this.cube.getId(), this.resolveCommand("ss", port), this.pollIterations, this.getSleepTime(), this.getTimeUnit())) continue block14;
                        return false;
                    }
                    catch (UnsupportedOperationException e) {
                        try {
                            if (this.executeWaitForIt(portBindings.getInternalIP(), port)) continue block14;
                            return false;
                        }
                        catch (UnsupportedOperationException ex) {
                            HasPortBindings.PortAddress mapping = portBindings.getMappedAddress(port.intValue());
                            if (mapping == null) {
                                throw new IllegalArgumentException("Can not use polling of type " + this.type + " on non externally bound port " + port);
                            }
                            log.fine(String.format("Pinging host %s and port %s with type", mapping.getIP(), mapping.getPort(), this.type));
                            if (Ping.ping(mapping.getIP(), mapping.getPort(), this.pollIterations, this.getSleepTime(), this.getTimeUnit())) continue block14;
                            return false;
                        }
                    }
                }
                case "waitforit": {
                    if (this.executeWaitForIt(portBindings.getInternalIP(), port)) break;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean executeWaitForIt(String containerIp, int port) {
        try {
            if (!this.alreadyCopiedWaitForIt) {
                Path waitForItLocation = this.copyWaitForItScriptToTempDir();
                this.dockerClientExecutor.copyStreamToContainer(this.cube.getId(), waitForItLocation.toFile(), new File(CONTAINER_DIRECTORY));
                this.alreadyCopiedWaitForIt = true;
            }
            String command = this.resolveWaitForItCommand(containerIp, port);
            String[] commands = new String[]{"sh", "-c", command};
            CubeOutput result = this.dockerClientExecutor.execStart(this.cube.getId(), commands);
            if (result.getError() != null && result.getError().contains("can't execute")) {
                throw new UnsupportedOperationException(result.getError());
            }
            return result.getStandard() != null && result.getStandard().trim().contains(MESSAGE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Path copyWaitForItScriptToTempDir() throws IOException {
        Path arquilliancube = Files.createTempDirectory("arquilliancube", new FileAttribute[0]);
        Path waitForItLocation = arquilliancube.resolve(Paths.get(WAIT_FOR_IT_SCRIPT, new String[0]));
        Files.copy(PollingAwaitStrategy.class.getResourceAsStream("/org/arquillian/cube/docker/impl/await/wait-for-it.sh"), waitForItLocation, new CopyOption[0]);
        Files.setPosixFilePermissions(waitForItLocation, this.getScriptPermissions());
        return waitForItLocation;
    }

    private Set<PosixFilePermission> getScriptPermissions() {
        PosixFilePermission ownerExecute = PosixFilePermission.OWNER_EXECUTE;
        PosixFilePermission groupExecute = PosixFilePermission.GROUP_EXECUTE;
        PosixFilePermission othersExecute = PosixFilePermission.OTHERS_EXECUTE;
        PosixFilePermission ownerRead = PosixFilePermission.OWNER_READ;
        PosixFilePermission groupRead = PosixFilePermission.GROUP_READ;
        PosixFilePermission othersRead = PosixFilePermission.OTHERS_READ;
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.addAll(Arrays.asList(ownerExecute, ownerRead, groupExecute, groupRead, othersExecute, othersRead));
        return perms;
    }

    private String resolveWaitForItCommand(String containerIp, int port) {
        return String.format("%s/%s %s:%s -s -- echo %s", CONTAINER_DIRECTORY, WAIT_FOR_IT_SCRIPT, containerIp, port, MESSAGE);
    }

    private String resolveCommand(String command, int port) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("port", Integer.toString(port));
        String templateContent = IOUtil.asStringPreservingNewLines((InputStream)PollingAwaitStrategy.class.getResourceAsStream(command + ".sh"));
        return IOUtil.replacePlaceholders((String)templateContent, values);
    }
}

