/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.config.IPAM;
import org.arquillian.cube.docker.impl.client.config.IPAMConfig;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.arquillian.cube.docker.impl.util.YamlUtil;

public class NetworkBuilder {
    private static final String DRIVER = "driver";
    private static final String DRIVER_OPTS = "driver_opts";
    private static final String IPAM = "ipam";
    private static final String DEFAULT_NETWORK_DRIVER = "bridge";
    private static final String SUBNET = "subnet";
    private static final String GATEWAY = "gateway";
    private static final String IP_RANGE = "iprange";
    private static final String CONFIG = "config";
    private Network configuration;

    public NetworkBuilder() {
        this(new Network());
    }

    protected NetworkBuilder(Network configuration) {
        this.configuration = configuration;
    }

    public Network build(Map<String, Object> dockerComposeContainerDefinition) {
        if (dockerComposeContainerDefinition != null && dockerComposeContainerDefinition.containsKey(DRIVER)) {
            this.addDriver(YamlUtil.asString(dockerComposeContainerDefinition, DRIVER));
        } else {
            this.addDriver(DEFAULT_NETWORK_DRIVER);
        }
        if (dockerComposeContainerDefinition != null) {
            if (dockerComposeContainerDefinition.containsKey(IPAM)) {
                this.addIpam(YamlUtil.asMap(dockerComposeContainerDefinition, IPAM));
            }
            if (dockerComposeContainerDefinition.containsKey(DRIVER_OPTS)) {
                this.configuration.setOptions(YamlUtil.asMapOfStrings(dockerComposeContainerDefinition, DRIVER_OPTS));
            }
        }
        return this.build();
    }

    public NetworkBuilder addDriver(String driver) {
        this.configuration.setDriver(driver);
        return this;
    }

    public NetworkBuilder withDefaultDriver() {
        this.configuration.setDriver(DEFAULT_NETWORK_DRIVER);
        return this;
    }

    public NetworkBuilder addIpam(Map<String, Object> ipamConfig) {
        IPAM ipam = new IPAM();
        if (ipamConfig != null) {
            if (ipamConfig.containsKey(DRIVER)) {
                ipam.setDriver(YamlUtil.asString(ipamConfig, DRIVER));
            }
            if (ipamConfig.containsKey(CONFIG)) {
                ipam.setIpamConfigs(this.createIpamConfig(YamlUtil.asListOfMap(ipamConfig, CONFIG)));
            }
        }
        this.configuration.setIpam(ipam);
        return this;
    }

    private List<IPAMConfig> createIpamConfig(Collection<Map<String, Object>> configs) {
        ArrayList<IPAMConfig> ipamConfigs = new ArrayList<IPAMConfig>();
        for (Map<String, Object> ipam : configs) {
            if (ipam == null) continue;
            IPAMConfig ipamConfig = new IPAMConfig();
            if (ipam.containsKey(SUBNET)) {
                ipamConfig.setSubnet(YamlUtil.asString(ipam, SUBNET));
            }
            if (ipam.containsKey(GATEWAY)) {
                ipamConfig.setGateway(YamlUtil.asString(ipam, GATEWAY));
            }
            if (ipam.containsKey(IP_RANGE)) {
                ipamConfig.setIpRange(YamlUtil.asString(ipam, IP_RANGE));
            }
            ipamConfigs.add(ipamConfig);
        }
        return ipamConfigs;
    }

    public Network build() {
        return this.configuration;
    }
}

