/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.arquillian.cube.containerobject.ConnectionMode;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.config.StarOperator;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.BindMode;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Container;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Network;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;

public class ContainerBuilder {
    private static final String TEMPORARY_FOLDER_PREFIX = "arquilliancube_";
    private static final String TEMPORARY_FOLDER_SUFFIX = ".build";
    private static final Logger logger = Logger.getLogger(ContainerBuilder.class.getName());
    private String id;
    private CubeContainer cubeContainer = new CubeContainer();

    private ContainerBuilder(String id) {
        this.id = id;
    }

    public static ContainerBuilder newContainer(String id) {
        return new ContainerBuilder(id);
    }

    public static ContainerBuilder newContainerFromImage(String image) {
        ContainerBuilder containerBuilder = new ContainerBuilder(ContainerBuilder.convertImageToId(image));
        containerBuilder.fromImage(image);
        return containerBuilder;
    }

    private static String convertImageToId(String imageId) {
        return imageId.replace('/', '_').replace(':', '_').replace('.', '_');
    }

    public ContainerOptionsBuilder fromImage(String image) {
        this.cubeContainer.setImage(Image.valueOf(image));
        return new ContainerOptionsBuilder();
    }

    public ContainerOptionsBuilder fromBuildDirectory(String directory) {
        BuildImage buildImage = new BuildImage(directory, null, true, true);
        this.cubeContainer.setBuildImage(buildImage);
        return new ContainerOptionsBuilder();
    }

    public ContainerOptionsBuilder fromBuildDirectory(Archive<?> buildDirectory) {
        File output = this.createTemporalDirectoryForCopyingDockerfile(this.id);
        logger.finer(String.format("Created %s directory for storing contents of %s cube.", output, this.id));
        ((ExplodedExporter)buildDirectory.as(ExplodedExporter.class)).exportExplodedInto(output);
        return this.fromBuildDirectory(output.getAbsolutePath());
    }

    private File createTemporalDirectoryForCopyingDockerfile(String containerName) {
        try {
            File dir = File.createTempFile(TEMPORARY_FOLDER_PREFIX + containerName, TEMPORARY_FOLDER_SUFFIX);
            dir.delete();
            if (!dir.mkdirs()) {
                throw new IllegalArgumentException("Temp Dir for storing Dockerfile contents could not be created.");
            }
            dir.deleteOnExit();
            return dir;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public class ContainerOptionsBuilder {
        private ContainerBuilder containerBuilder;
        private ConnectionMode connectionMode = ConnectionMode.START_AND_STOP_AROUND_CLASS;

        public ContainerOptionsBuilder withConnectionMode(ConnectionMode connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        public ContainerOptionsBuilder withExposedPorts(Integer ... ports) {
            List<ExposedPort> exposedPortList = Arrays.stream(ports).map(ExposedPort::valueOf).collect(Collectors.toList());
            this.setExposedPorts(exposedPortList);
            return this;
        }

        public ContainerOptionsBuilder withExposedPorts(String ... ports) {
            List<ExposedPort> exposedPortList = Arrays.stream(ports).map(ExposedPort::valueOf).collect(Collectors.toList());
            this.setExposedPorts(exposedPortList);
            return this;
        }

        public ContainerOptionsBuilder withPortBinding(Integer ... ports) {
            List<PortBinding> portBindingList = Arrays.stream(ports).map(port -> Integer.toString(port)).map(PortBinding::valueOf).collect(Collectors.toList());
            this.setPortBinding(portBindingList);
            return this;
        }

        public ContainerOptionsBuilder withPortBinding(String ... ports) {
            List<PortBinding> portBindingList = Arrays.stream(ports).map(PortBinding::valueOf).collect(Collectors.toList());
            this.setPortBinding(portBindingList);
            return this;
        }

        public ContainerOptionsBuilder withEnvironment(String key, Object value, Object ... keyValues) {
            if (keyValues.length % 2 != 0) {
                throw new IllegalArgumentException("Key Values should be a pair of key, value");
            }
            ArrayList<String> environment = new ArrayList<String>();
            environment.add(this.toEnv(key, value));
            for (int i = 0; i < keyValues.length; i += 2) {
                environment.add(this.toEnv(keyValues[i], keyValues[i + 1]));
            }
            this.setEnvironment(environment);
            return this;
        }

        public ContainerOptionsBuilder withCommand(String command) {
            ContainerBuilder.this.cubeContainer.setCmd(Arrays.asList(command.split(" ")));
            return this;
        }

        public ContainerOptionsBuilder withCommand(String ... command) {
            ContainerBuilder.this.cubeContainer.setCmd(Arrays.asList(command));
            return this;
        }

        public ContainerOptionsBuilder withVolume(String hostPath, String containerPath) {
            return this.withVolume(hostPath, containerPath, BindMode.READ_WRITE);
        }

        public ContainerOptionsBuilder withVolume(String hostPath, String containerPath, BindMode bindMode) {
            this.setVolume(hostPath + ":" + containerPath + ":" + bindMode.accessMode.name());
            return this;
        }

        public ContainerOptionsBuilder withNetworkMode(String networkMode) {
            ContainerBuilder.this.cubeContainer.setNetworkMode(networkMode);
            return this;
        }

        public ContainerOptionsBuilder withNetworkMode(Network networkMode) {
            return this.withNetworkMode(networkMode.getId());
        }

        public ContainerOptionsBuilder withNetworks(String ... networks) {
            ContainerBuilder.this.cubeContainer.setNetworks(Arrays.asList(networks));
            return this;
        }

        public ContainerOptionsBuilder withNetworks(Network ... networks) {
            return this.withNetworks((String[])Arrays.stream(networks).map(Network::getId).toArray(String[]::new));
        }

        public ContainerOptionsBuilder withPriviledgedMode(boolean mode) {
            ContainerBuilder.this.cubeContainer.setPrivileged(mode);
            return this;
        }

        public ContainerOptionsBuilder withLink(String link) {
            this.setLink(link);
            return this;
        }

        public ContainerOptionsBuilder withLink(String service, String alias) {
            return this.withLink(service + ":" + alias);
        }

        public ContainerOptionsBuilder withLink(Container container) {
            return this.withLink(container.getContainerName(), container.getContainerName());
        }

        public ContainerOptionsBuilder withAwaitStrategy(Await awaitStrategy) {
            ContainerBuilder.this.cubeContainer.setAwait(awaitStrategy);
            return this;
        }

        public Container build() {
            if (ContainerBuilder.this.id.endsWith("*")) {
                UUID uuid = UUID.randomUUID();
                StarOperator.adaptPortBindingToParallelRun(ContainerBuilder.this.cubeContainer);
                StarOperator.adaptLinksToParallelRun(uuid, ContainerBuilder.this.cubeContainer);
                StarOperator.adaptDependenciesToParallelRun(uuid, ContainerBuilder.this.cubeContainer);
                String templateName = ContainerBuilder.this.id.substring(0, ContainerBuilder.this.id.lastIndexOf(42));
                ContainerBuilder.this.id = StarOperator.generateNewName(templateName, uuid);
            }
            return new Container(ContainerBuilder.this.id, ContainerBuilder.this.cubeContainer, this.connectionMode);
        }

        private String toEnv(Object key, Object value) {
            return key.toString() + "=" + value.toString();
        }

        private void setExposedPorts(List<ExposedPort> exposedPorts) {
            if (ContainerBuilder.this.cubeContainer.getExposedPorts() == null) {
                ContainerBuilder.this.cubeContainer.setExposedPorts(exposedPorts);
            } else {
                ContainerBuilder.this.cubeContainer.getExposedPorts().addAll(exposedPorts);
            }
        }

        private void setPortBinding(List<PortBinding> portBindings) {
            if (ContainerBuilder.this.cubeContainer.getPortBindings() == null) {
                ContainerBuilder.this.cubeContainer.setPortBindings(portBindings);
            } else {
                ContainerBuilder.this.cubeContainer.getPortBindings().addAll(portBindings);
            }
        }

        private void setEnvironment(List<String> environments) {
            if (ContainerBuilder.this.cubeContainer.getEnv() == null) {
                ContainerBuilder.this.cubeContainer.setEnv(environments);
            } else {
                ContainerBuilder.this.cubeContainer.getEnv().addAll(environments);
            }
        }

        private void setVolume(String volume) {
            if (ContainerBuilder.this.cubeContainer.getBinds() == null) {
                ArrayList<String> binds = new ArrayList<String>();
                binds.add(volume);
                ContainerBuilder.this.cubeContainer.setBinds(binds);
            } else {
                ContainerBuilder.this.cubeContainer.getBinds().add(volume);
            }
        }

        private void setLink(String link) {
            if (ContainerBuilder.this.cubeContainer.getLinks() == null) {
                ArrayList<Link> links = new ArrayList<Link>();
                links.add(Link.valueOf(link));
                ContainerBuilder.this.cubeContainer.setLinks(links);
            } else {
                ContainerBuilder.this.cubeContainer.getLinks().add(Link.valueOf(link));
            }
        }
    }
}

