/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.client.config.Await;

public class AwaitBuilder {
    private static final int DEFAULT_TIMEOUT = 30;

    public static Await logAwait(String matching) {
        return AwaitBuilder.logAwait(matching, 30, 1);
    }

    public static Await logAwait(String matching, int occurrences) {
        return AwaitBuilder.logAwait(matching, 30, occurrences);
    }

    public static Await logAwait(String matching, int timeoutInSeconds, int occurrences) {
        Await await = new Await();
        await.setStrategy("log");
        await.setMatch(matching);
        await.setTimeout(timeoutInSeconds);
        await.setStdOut(true);
        await.setOccurrences(occurrences);
        return await;
    }

    public static HttpAwaitBuilder httpAwait(String path, int port) {
        URL url = AwaitBuilder.createUrl("http", path, port);
        return AwaitBuilder.httpAwait(url, null);
    }

    public static HttpAwaitBuilder httpsAwait(String path, int port) {
        URL url = AwaitBuilder.createUrl("https", path, port);
        return AwaitBuilder.httpAwait(url, null);
    }

    private static URL createUrl(String protocol, String path, int port) {
        URL url;
        try {
            url = new URL(protocol, "dockerHost", port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        return url;
    }

    public static HttpAwaitBuilder httpAwait(URL serviceUrl, String messageContent) {
        return new HttpAwaitBuilder(serviceUrl, messageContent);
    }

    public static Await defaultHttpAwait(URL serviceUrl, String messageContent, int statusCode) {
        return AwaitBuilder.httpAwait(serviceUrl, messageContent).withResponseCode(statusCode).build();
    }

    public static class HttpAwaitBuilder {
        private Await await = new Await();

        public HttpAwaitBuilder(URL url, String messageContent) {
            this.await.setStrategy("http");
            this.await.setMatch(messageContent);
            this.await.setUrl(url.toExternalForm());
            this.await.setSleepPollingTime("30 s");
            this.await.setIterations(10);
        }

        public HttpAwaitBuilder withResponseCode(int responseCode) {
            this.await.setResponseCode(responseCode);
            return this;
        }

        public HttpAwaitBuilder withSleepPollingTime(int time, TimeUnit unit) {
            long l = unit.toMillis(time);
            this.await.setSleepPollingTime(l + "ms");
            return this;
        }

        public HttpAwaitBuilder withIterations(int iterations) {
            this.await.setIterations(iterations);
            return this;
        }

        public HttpAwaitBuilder withHeaders(Map<String, Object> headers) {
            this.await.setHeaders(headers);
            return this;
        }

        public HttpAwaitBuilder withHeaders(String key, Object value, Object ... keyValues) {
            if (keyValues.length % 2 != 0) {
                throw new IllegalArgumentException("Key Values should be a pair of key, value");
            }
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put(key, value);
            for (int i = 0; i < keyValues.length; i += 2) {
                headers.put((String)keyValues[i], keyValues[i + 1]);
            }
            return this.withHeaders(headers);
        }

        public Await build() {
            return this.await;
        }
    }
}

