/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.arquillian.cube.docker.impl.docker.compose.ContainerBuilder;
import org.arquillian.cube.docker.impl.docker.compose.NetworkBuilder;
import org.arquillian.cube.docker.impl.util.YamlUtil;

public class ComposeBuilder {
    private DockerCompositions configuration;
    private static final String SERVICES = "services";
    private static final String NETWORKS = "networks";
    private static final String IP_V4_Address = "ipv4_address";
    private static final String IP_V6_Address = "ipv6_address";
    private static final String ALIASES = "aliases";
    private static final String NETWORK_NAME_SUFFIX = "_default";
    private Path dockerComposeRootLocation;

    ComposeBuilder(Path dockerComposeRootLocation) {
        this(dockerComposeRootLocation, new DockerCompositions());
    }

    private ComposeBuilder(Path dockerComposeRootLocation, DockerCompositions configuration) {
        this.dockerComposeRootLocation = dockerComposeRootLocation;
        this.configuration = configuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DockerCompositions build(Map<String, Object> dockerComposeContainerDefinition) {
        Set<String> keys;
        if (dockerComposeContainerDefinition.containsKey(SERVICES)) {
            Map<String, Object> servicesDefinition = YamlUtil.asMap(dockerComposeContainerDefinition, SERVICES);
            keys = servicesDefinition.keySet();
            for (String key : keys) {
                ContainerBuilder services = new ContainerBuilder(this.dockerComposeRootLocation);
                CubeContainer cubeContainer = services.build(YamlUtil.asMap(servicesDefinition, key), "2");
                if (!dockerComposeContainerDefinition.containsKey(NETWORKS)) {
                    String networkName = this.getDefaultNetworkName();
                    cubeContainer.setNetworks(Arrays.asList(networkName));
                    cubeContainer.setNetworkMode(networkName);
                } else {
                    Map<String, Object> serviceDefinition = YamlUtil.asMap(servicesDefinition, key);
                    if (serviceDefinition.containsKey(NETWORKS)) {
                        Collection<String> serviceNetworks;
                        Map<String, Object> serviceNetworksConfig = null;
                        if (serviceDefinition.get(NETWORKS) instanceof ArrayList) {
                            serviceNetworks = YamlUtil.asListOfString(serviceDefinition, NETWORKS);
                        } else {
                            serviceNetworksConfig = YamlUtil.asMap(serviceDefinition, NETWORKS);
                            serviceNetworks = serviceNetworksConfig.keySet();
                        }
                        if (serviceNetworks.isEmpty()) throw new IllegalArgumentException("Networks not mentioned under services networks section.");
                        cubeContainer.setNetworks(new HashSet<String>(serviceNetworks));
                        String networkName = serviceNetworks.iterator().next();
                        cubeContainer.setNetworkMode(networkName);
                        if (serviceNetworksConfig != null) {
                            LinkedHashMap configOption = (LinkedHashMap)serviceNetworksConfig.get(networkName);
                            this.setNetworkOptions(configOption, cubeContainer);
                        }
                    } else {
                        String networkName = this.getDefaultNetworkName();
                        if (!this.configuration.getNetworks().containsKey(networkName)) {
                            NetworkBuilder networkBuilder = new NetworkBuilder();
                            Network network = networkBuilder.withDefaultDriver().build();
                            this.configuration.add(networkName, network);
                        }
                        cubeContainer.setNetworks(Arrays.asList(networkName));
                        cubeContainer.setNetworkMode(networkName);
                    }
                }
                this.configuration.add(key, cubeContainer);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(NETWORKS)) {
            Map<String, Object> networksDefinition = YamlUtil.asMap(dockerComposeContainerDefinition, NETWORKS);
            keys = networksDefinition.keySet();
            for (String key : keys) {
                NetworkBuilder networks = new NetworkBuilder();
                Network network = networks.build(YamlUtil.asMap(networksDefinition, key));
                this.configuration.add(key, network);
            }
            return this.configuration;
        } else {
            String networkName = this.getDefaultNetworkName();
            NetworkBuilder networkBuilder = new NetworkBuilder();
            Network network = networkBuilder.withDefaultDriver().build();
            this.configuration.add(networkName, network);
        }
        return this.configuration;
    }

    private String getDefaultNetworkName() {
        return this.dockerComposeRootLocation.toFile().getAbsoluteFile().getParentFile().getName() + NETWORK_NAME_SUFFIX;
    }

    private void setNetworkOptions(Map<String, Object> networkOption, CubeContainer cubeContainer) {
        if (networkOption != null) {
            if (networkOption.containsKey(IP_V4_Address)) {
                cubeContainer.setIpv4Address(YamlUtil.asString(networkOption, IP_V4_Address));
            }
            if (networkOption.containsKey(IP_V6_Address)) {
                cubeContainer.setIpv6Address(YamlUtil.asString(networkOption, IP_V6_Address));
            }
            if (networkOption.containsKey(ALIASES)) {
                cubeContainer.setAliases(YamlUtil.asListOfString(networkOption, ALIASES));
            }
        }
    }
}

