/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemInterface;

public enum OperatingSystem implements OperatingSystemInterface
{
    LINUX_OS("Linux", OperatingSystemFamily.LINUX),
    MAC_OSX("Mac OS X", OperatingSystemFamily.MAC),
    MAC_OS("Mac OS", OperatingSystemFamily.MAC),
    WINDOWS_95("Windows 95", OperatingSystemFamily.WINDOWS),
    WINDOWS_98("Windows 98", OperatingSystemFamily.WINDOWS),
    WINDOWS_ME("Windows Me", OperatingSystemFamily.WINDOWS),
    WINDOWS_NT("Windows NT", OperatingSystemFamily.WINDOWS),
    WINDOWS_2000("Windows 2000", OperatingSystemFamily.WINDOWS),
    WINDOWS_XP("Windows XP", OperatingSystemFamily.WINDOWS),
    WINDOWS_7("Windows 7", OperatingSystemFamily.WINDOWS),
    WINDOWS_8("Windows 8", OperatingSystemFamily.WINDOWS),
    WINDOWS_10("Windows 10", OperatingSystemFamily.WINDOWS),
    WINDOWS_2003("Windows 2003", OperatingSystemFamily.WINDOWS),
    WINDOWS_2008("Windows 2008", OperatingSystemFamily.WINDOWS),
    SUN_OS("Sun OS ", OperatingSystemFamily.UNIX),
    MPE_IX("MPE/iX", OperatingSystemFamily.UNIX),
    HP_UX("HP-UX", OperatingSystemFamily.UNIX),
    AIX("AIX", OperatingSystemFamily.UNIX),
    OS_390("OS/390", OperatingSystemFamily.UNIX),
    FREEBSD("FreeBSD", OperatingSystemFamily.UNIX),
    IRIX("Irix", OperatingSystemFamily.UNIX),
    DIGITAL_UNIX("Digital Unix", OperatingSystemFamily.UNIX),
    NETWARE_4_11("NetWare 4.11", OperatingSystemFamily.UNIX),
    OSF1("OSF1", OperatingSystemFamily.UNIX),
    OPENVMS("OpenVMS", OperatingSystemFamily.DEC_OS),
    UNKNOWN_OS("Unknown", OperatingSystemFamily.UNKNOWN);

    private final String label;
    private final OperatingSystemFamily family;
    private final OperatingSystemFamily default_family;

    private OperatingSystem(String label, OperatingSystemFamily family) {
        this.label = label;
        this.family = family;
        this.default_family = label.startsWith("Windows") ? OperatingSystemFamily.WINDOWS_NPIPE : OperatingSystemFamily.UNIX;
    }

    public static OperatingSystem resolve(String osName) {
        for (OperatingSystem os : OperatingSystem.values()) {
            if (!os.label.equalsIgnoreCase(osName)) continue;
            return os;
        }
        return UNKNOWN_OS;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public OperatingSystemFamily getFamily() {
        return this.family;
    }

    @Override
    public OperatingSystemFamily getDefaultFamily() {
        return this.default_family;
    }
}

