/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.reporter;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.impl.event.AfterStart;
import org.arquillian.cube.kubernetes.impl.event.Start;
import org.arquillian.cube.kubernetes.reporter.KubernetesReportKey;
import org.arquillian.cube.kubernetes.reporter.KubernetesSection;
import org.arquillian.reporter.api.builder.Reporter;
import org.arquillian.reporter.api.builder.report.ReportBuilder;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.model.StringKey;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class TakeKubernetesResourcesInformation {
    @Inject
    Event<SectionEvent> sectionEvent;
    @Inject
    Instance<DependencyResolver> dependencyResolver;

    public void reportKubernetesConfiguration(@Observes Start start, Configuration configuration, ReporterConfiguration reporterConfiguration) throws IOException {
        ReportBuilder reportBuilder = Reporter.createReport((StringKey)KubernetesReportKey.CONFIGURATION);
        Session session = start.getSession();
        if (configuration != null) {
            reportBuilder.addEntries(this.getFilesForResourcesConfiguration(session, configuration, reporterConfiguration));
        }
        Reporter.createReport((StringKey)KubernetesReportKey.KUBERNETES_SECTION_NAME).addReport(reportBuilder).inSection((SectionEvent)new KubernetesSection()).fire(this.sectionEvent);
    }

    public void reportSessionStatus(@Observes AfterStart afterStart, KubernetesClient kubernetesClient) {
        Session session = afterStart.getSession();
        if (session != null) {
            String namespace = session.getNamespace();
            Reporter.createReport((StringKey)KubernetesReportKey.SESSION_STATUS).addKeyValueEntry(KubernetesReportKey.NAMESPACE, namespace).addKeyValueEntry(KubernetesReportKey.MASTER_URL, String.valueOf(kubernetesClient.getMasterUrl())).inSection((SectionEvent)new KubernetesSection()).asSubReport().fire(this.sectionEvent);
        }
    }

    private List<FileEntry> getFilesForResourcesConfiguration(Session session, Configuration configuration, ReporterConfiguration reporterConfiguration) throws IOException {
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        URL environmentConfigUrl = configuration.getEnvironmentConfigUrl();
        if (environmentConfigUrl != null) {
            fileEntries.add(this.getFileForResourcesConfiguration(environmentConfigUrl, reporterConfiguration));
        }
        if (configuration.isEnvironmentInitEnabled()) {
            List dependencyUrls = !configuration.getEnvironmentDependencies().isEmpty() ? configuration.getEnvironmentDependencies() : ((DependencyResolver)this.dependencyResolver.get()).resolve(session);
            for (URL dependencyUrl : dependencyUrls) {
                fileEntries.add(this.getFileForResourcesConfiguration(dependencyUrl, reporterConfiguration));
            }
        }
        return fileEntries;
    }

    private FileEntry getFileForResourcesConfiguration(URL url, ReporterConfiguration reporterConfiguration) throws IOException {
        Path rootDir = Paths.get(reporterConfiguration.getRootDirectory(), new String[0]);
        String filePath = this.relativizePath(url, rootDir);
        return new FileEntry(filePath);
    }

    private String relativizePath(URL url, Path rootDir) {
        String filePath;
        String absoluteRootDir;
        String pathURL = url.toString();
        if (pathURL.contains(absoluteRootDir = new File(rootDir.toString()).getAbsolutePath())) {
            Path rootDirPath = Paths.get(absoluteRootDir, new String[0]);
            Path configFilePath = Paths.get(url.getFile(), new String[0]);
            Path relativize = rootDirPath.relativize(configFilePath);
            filePath = relativize.toString();
        } else {
            filePath = pathURL;
        }
        return filePath;
    }
}

