/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import java.util.HashMap;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.Session;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.AfterTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.BeforeTestLifecycleEvent;

public class TestListener {
    public void start(@Observes(precedence=-2147483648) BeforeTestLifecycleEvent event, NamespaceService namespaceService, Session session) {
        String pkg = event.getTestClass().getJavaClass().getPackage().getName();
        String className = event.getTestClass().getJavaClass().getSimpleName();
        String methodName = event.getTestMethod().getName();
        HashMap<String, String> annotations = new HashMap<String, String>();
        String testCase = TestListener.trimName(pkg, className, methodName);
        annotations.put(String.format("fabric8.io/test-status-%s", testCase), "RUNNING");
        namespaceService.annotate(session.getNamespace(), annotations);
    }

    public void stop(@Observes(precedence=-2147483648) AfterTestLifecycleEvent event, TestResult result, NamespaceService namespaceService, Session session) {
        String pkg = event.getTestClass().getJavaClass().getPackage().getName();
        String className = event.getTestClass().getJavaClass().getSimpleName();
        String methodName = event.getTestMethod().getName();
        HashMap<String, String> annotations = new HashMap<String, String>();
        String testCase = TestListener.trimName(pkg, className, methodName);
        annotations.put(String.format("fabric8.io/test-status-%s", testCase), result.getStatus().name());
        namespaceService.annotate(session.getNamespace(), annotations);
        switch (result.getStatus()) {
            case PASSED: {
                session.getPassed().incrementAndGet();
                break;
            }
            case FAILED: {
                session.getFailed().incrementAndGet();
                break;
            }
            case SKIPPED: {
                session.getSkiped().incrementAndGet();
            }
        }
    }

    static String trimName(String packageName, String className, String methodName) {
        StringBuilder sb = new StringBuilder();
        sb.append(TestListener.trimPackage(packageName)).append(".").append(className).append(".").append(methodName);
        String result = sb.toString();
        int prefixLength = "fabric8.io/test-status-%s".length() - 1;
        if (prefixLength + result.length() > 63) {
            result = result.substring(prefixLength + result.length() - 63);
        }
        if (result.charAt(0) == '.') {
            result = result.substring(1);
        }
        return result;
    }

    static String trimPackage(String pkg) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String part : pkg.split("\\.")) {
            if (first) {
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(part.substring(0, 1));
        }
        return sb.toString();
    }
}

