/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.await;

import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Session;

public class SessionServicesAreReady
implements Callable<Boolean> {
    private final Session session;
    private final KubernetesClient kubernetesClient;
    private final Configuration configuration;

    public SessionServicesAreReady(KubernetesClient kubernetesClient, Session session, Configuration configuration) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
        this.configuration = configuration;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        List services = ((ServiceList)((ClientNonNamespaceOperation)this.kubernetesClient.services().inNamespace(this.session.getNamespace())).list()).getItems();
        if (services.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No services are available yet, waiting...");
        } else if (this.configuration.isWaitForServiceConnectionEnabled()) {
            for (Service s : this.filterServices(services, this.configuration.getWaitForServiceList())) {
                if (this.isEndpointAvailable(s)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isEndpointAvailable(Service s) {
        String sid;
        boolean result;
        block21: {
            List subsets;
            String serviceStatus = null;
            result = false;
            sid = s.getMetadata().getName();
            String namespace = this.session.getNamespace();
            Endpoints endpoints = (Endpoints)((ClientResource)((ClientNonNamespaceOperation)this.kubernetesClient.endpoints().inNamespace(namespace)).withName(sid)).get();
            ServiceSpec spec = s.getSpec();
            if (endpoints == null || spec == null || (subsets = endpoints.getSubsets()) == null) break block21;
            for (EndpointSubset subset : subsets) {
                List addresses = subset.getAddresses();
                if (addresses == null) continue;
                for (EndpointAddress address : addresses) {
                    String ip;
                    String addr = ip = address.getIp();
                    List ports = spec.getPorts();
                    for (ServicePort port : ports) {
                        block22: {
                            boolean bl;
                            Throwable throwable;
                            Socket socket;
                            block19: {
                                block20: {
                                    Integer portNumber = port.getPort();
                                    if (portNumber == null || portNumber <= 0) continue;
                                    if (!this.configuration.isWaitForServiceConnectionEnabled()) break block22;
                                    socket = new Socket();
                                    throwable = null;
                                    socket.connect(new InetSocketAddress(ip, (int)portNumber), (int)this.configuration.getWaitForServiceConnectionTimeout());
                                    serviceStatus = "Service: " + sid + " is ready. Provider:" + addr + ".";
                                    bl = true;
                                    if (socket == null) break block19;
                                    if (throwable == null) break block20;
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block19;
                                }
                                socket.close();
                            }
                            this.session.getLogger().warn(serviceStatus);
                            return bl;
                            catch (Throwable throwable3) {
                                try {
                                    try {
                                        try {
                                            throwable = throwable3;
                                            throw throwable3;
                                        }
                                        catch (Throwable throwable4) {
                                            if (socket != null) {
                                                if (throwable != null) {
                                                    try {
                                                        socket.close();
                                                    }
                                                    catch (Throwable throwable5) {
                                                        throwable.addSuppressed(throwable5);
                                                    }
                                                } else {
                                                    socket.close();
                                                }
                                            }
                                            throw throwable4;
                                        }
                                    }
                                    catch (Exception e) {
                                        serviceStatus = "Service: " + sid + " is not ready! in namespace " + namespace + ". Error: " + e.getMessage();
                                        this.session.getLogger().warn(serviceStatus);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable6) {
                                    this.session.getLogger().warn(serviceStatus);
                                    throw throwable6;
                                }
                            }
                        }
                        serviceStatus = "Service: " + sid + " is ready. Not testing connecting to it!. Provider:" + addr + ".";
                        this.session.getLogger().warn(serviceStatus);
                        return true;
                    }
                }
            }
        }
        this.session.getLogger().warn("Service: " + sid + " has no valid endpoints");
        return result;
    }

    private List<Service> filterServices(List<Service> services, List<String> selectedIds) {
        if (selectedIds != null && !selectedIds.isEmpty()) {
            ArrayList<Service> result = new ArrayList<Service>();
            for (Service s : services) {
                String sid = s.getMetadata().getName();
                if (!selectedIds.contains(sid)) continue;
                result.add(s);
            }
            return result;
        }
        return services;
    }
}

