/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdySetting;
import java.util.Collections;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class SpdyChannelWithoutFlowControl
extends SpdyChannel {
    private int initialWindowSize;
    private int currentWindowSize;

    public SpdyChannelWithoutFlowControl(StreamConnection connectedStreamChannel, ByteBufferPool bufferPool, PooledByteBuffer data, ByteBufferPool heapBufferPool, boolean clientSide, OptionMap options) {
        super(connectedStreamChannel, bufferPool, data, heapBufferPool, clientSide, options);
        this.currentWindowSize = this.initialWindowSize = this.getInitialWindowSize();
    }

    synchronized int grabFlowControlBytes(int bytesToGrab) {
        this.currentWindowSize += bytesToGrab;
        this.updateSettings(Collections.singletonList(new SpdySetting(0, 7, this.currentWindowSize)));
        super.updateReceiveFlowControlWindow(this.currentWindowSize);
        return super.grabFlowControlBytes(bytesToGrab);
    }
}

