/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.visitor;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class DockerRegistryVisitor
extends TypedVisitor<ContainerBuilder> {
    private static final Pattern IMAGE_PATTERN = Pattern.compile("^(.+?)(?::([^:/]+))?$");
    private static final String SPLIT_REGEX = "\\s*/\\s*";
    private static final String DOT = ".";
    private static final String COLN = ":";
    private static final String SEPARATOR = "/";
    @Inject
    Instance<Configuration> configuration;

    public void visit(ContainerBuilder containerBuilder) {
        String registry = ((Configuration)this.configuration.get()).getDockerRegistry();
        if (Strings.isNotNullOrEmpty((String)registry) && !DockerRegistryVisitor.hasRegistry(containerBuilder.getImage())) {
            containerBuilder.withImage(registry + SEPARATOR + containerBuilder.getImage());
        }
    }

    public static boolean hasRegistry(String imageName) {
        if (imageName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        Matcher matcher = IMAGE_PATTERN.matcher(imageName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(imageName + " is not a proper image name ([registry/][repo][:port]");
        }
        String rest = matcher.group(1);
        String[] parts = rest.split(SPLIT_REGEX);
        String part = parts[0];
        return part.contains(DOT) || part.contains(COLN);
    }
}

