/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.namespace;

import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.io.IOException;
import java.util.Map;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.LabelProvider;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class DefaultNamespaceService
implements NamespaceService {
    private static final String PROJECT_LABEL = "project";
    private static final String FRAMEWORK_LABEL = "framework";
    private static final String COMPONENT_LABEL = "component";
    private static final String ARQUILLIAN_FRAMEWORK = "arquillian";
    private static final String ITEST_COMPONENT = "integrationTest";
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<LabelProvider> labelProvider;
    @Inject
    protected Instance<Logger> logger;
    @Inject
    protected Instance<Configuration> configuration;

    @Override
    public Namespace create(String namespace) {
        return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)((DoneableNamespace)((KubernetesClient)this.client.get()).namespaces().createNew()).withNewMetadata().withName(namespace)).addToLabels(((LabelProvider)this.labelProvider.get()).getLabels())).addToLabels(PROJECT_LABEL, ((KubernetesClient)this.client.get()).getNamespace())).addToLabels(FRAMEWORK_LABEL, ARQUILLIAN_FRAMEWORK)).addToLabels(COMPONENT_LABEL, ITEST_COMPONENT)).endMetadata()).done();
    }

    @Override
    public Namespace annotate(String namespace, Map<String, String> annotations) {
        return ((DoneableNamespace)((NamespaceFluent.MetadataNested)((DoneableNamespace)((ClientResource)((KubernetesClient)this.client.get()).namespaces().withName(namespace)).edit()).editMetadata().addToAnnotations(annotations)).endMetadata()).done();
    }

    @Override
    public Boolean delete(String namespace) {
        return (Boolean)((ClientResource)((KubernetesClient)this.client.get()).namespaces().withName(namespace)).delete();
    }

    @Override
    public Boolean exists(String namespace) {
        return ((ClientResource)((KubernetesClient)this.client.get()).namespaces().withName(namespace)).get() != null;
    }

    @Override
    public void clean(String namespace) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        ((ClientNonNamespaceOperation)client.extensions().deployments().inNamespace(namespace)).delete();
        ((ClientNonNamespaceOperation)client.extensions().replicaSets().inNamespace(namespace)).delete();
        ((ClientNonNamespaceOperation)client.replicationControllers().inNamespace(namespace)).delete();
        ((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).delete();
        ((ClientNonNamespaceOperation)client.extensions().ingresses().inNamespace(namespace)).delete();
        ((ClientNonNamespaceOperation)client.services().inNamespace(namespace)).delete();
        ((ClientResource)client.securityContextConstraints().withName(namespace)).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(String namespace) {
        block11: {
            Logger logger = (Logger)this.logger.get();
            Configuration configuration = (Configuration)this.configuration.get();
            try {
                if (configuration.isNamespaceCleanupConfirmationEnabled()) {
                    this.showErrors();
                    logger.info("");
                    logger.info("Waiting to destroy the namespace.");
                    logger.info("Please type: [Q] to terminate the namespace.");
                    try {
                        while (true) {
                            int ch;
                            if ((ch = System.in.read()) < 0 || ch == 81) {
                                logger.info("Stopping...");
                                break block11;
                            }
                            logger.info("Found character: " + Character.toString((char)ch));
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Failed to read from input. " + e);
                        break block11;
                    }
                }
                long timeout = configuration.getNamespaceCleanupTimeout();
                if (timeout > 0L) {
                    this.showErrors();
                    logger.info("");
                    logger.info("Sleeping for " + timeout + " seconds until destroying the namespace");
                    try {
                        Thread.sleep(timeout * 1000L);
                    }
                    catch (InterruptedException e) {
                        logger.info("Interupted sleeping to GC the namespace: " + e);
                    }
                }
            }
            finally {
                this.delete(namespace);
            }
        }
    }

    private void showErrors() {
    }
}

