/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionCreatedListener;
import org.arquillian.cube.kubernetes.impl.ShutdownHook;
import org.jboss.arquillian.core.spi.Validate;

public class SessionManager
implements SessionCreatedListener {
    private final Session session;
    private final KubernetesClient client;
    private final Configuration configuration;
    private final AnnotationProvider annotationProvider;
    private final NamespaceService namespaceService;
    private final KubernetesResourceLocator kubernetesResourceLocator;
    private final DependencyResolver dependencyResolver;
    private final ResourceInstaller resourceInstaller;
    private final AtomicReference<ShutdownHook> shutdownHookRef = new AtomicReference();

    public SessionManager(Session session, KubernetesClient client, Configuration configuration, AnnotationProvider annotationProvider, NamespaceService namespaceService, KubernetesResourceLocator kubernetesResourceLocator, DependencyResolver dependencyResolver, ResourceInstaller resourceInstaller) {
        Validate.notNull((Object)session, (String)"A Session instance is required.");
        Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
        Validate.notNull((Object)configuration, (String)"Configuration is required.");
        Validate.notNull((Object)annotationProvider, (String)"An AnnotationProvider instance is required.");
        Validate.notNull((Object)namespaceService, (String)"A NamespaceService instance is required.");
        Validate.notNull((Object)dependencyResolver, (String)"A DependencyResolver instance is required.");
        Validate.notNull((Object)kubernetesResourceLocator, (String)"A KubernetesResourceLocator instance is required.");
        Validate.notNull((Object)resourceInstaller, (String)"A ResourceInstaller instance is required.");
        this.session = session;
        this.client = client;
        this.configuration = configuration;
        this.annotationProvider = annotationProvider;
        this.namespaceService = namespaceService;
        this.kubernetesResourceLocator = kubernetesResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.resourceInstaller = resourceInstaller;
    }

    @Override
    public void start() {
        ShutdownHook hook = null;
        Logger log = this.session.getLogger();
        String namespace = this.session.getNamespace();
        log.status("Using Kubernetes at: " + this.client.getMasterUrl());
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     oc project " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl namespace " + namespace);
        Map<String, String> namespaceAnnotations = this.annotationProvider.create(this.session.getId(), "RUNNING");
        String namespaceToUse = this.configuration.getNamespace();
        if (Strings.isNullOrEmpty((String)namespaceToUse)) {
            this.namespaceService.create(this.session.getNamespace(), namespaceAnnotations);
        } else if (!this.namespaceService.exists(this.session.getNamespace()).booleanValue()) {
            if (this.configuration.isNamespaceLazyCreateEnabled()) {
                this.namespaceService.create(this.session.getNamespace(), namespaceAnnotations);
            } else {
                throw new IllegalStateException("Namespace [" + this.session.getNamespace() + "] doesn't exists");
            }
        }
        hook = new ShutdownHook(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.clean("ABORTED");
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        this.shutdownHookRef.set(hook);
        ArrayList<HasMetadata> all = new ArrayList<HasMetadata>();
        try {
            List<URL> dependencyUrls;
            URL configUrl = this.configuration.getEnvironmentConfigUrl();
            List<URL> list = dependencyUrls = !this.configuration.getEnvironmentDependencies().isEmpty() ? this.configuration.getEnvironmentDependencies() : this.dependencyResolver.resolve(this.session);
            if (this.configuration.isEnvironmentInitEnabled()) {
                for (URL dependencyUrl : dependencyUrls) {
                    log.info("Found dependency: " + dependencyUrl);
                    all.addAll(this.resourceInstaller.install(dependencyUrl));
                }
                if (configUrl == null) {
                    configUrl = this.kubernetesResourceLocator.locate();
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    InputStream is = configUrl.openStream();
                    Object object = null;
                    try {
                        all.addAll(this.resourceInstaller.install(configUrl));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (object != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                } else {
                    log.warn("Did not find any kubernetes configuration.");
                }
                if (!all.isEmpty()) {
                    try {
                        this.client.resourceList(all).waitUntilReady(this.configuration.getWaitTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (KubernetesClientTimeoutException t) {
                        log.warn("The are resources in not ready state.");
                        for (HasMetadata r : t.getResourcesNotReady()) {
                            log.error(r.getKind() + " name: " + r.getMetadata().getName() + " namespace:" + r.getMetadata().getNamespace());
                        }
                        throw new IllegalStateException("Environment not initialized in time.", t);
                    }
                }
            }
            this.display();
        }
        catch (Exception e) {
            try {
                this.clean("ERROR");
            }
            catch (Exception me) {
                throw new RuntimeException(e);
            }
            finally {
                if (hook != null) {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.clean(this.getSessionStatus(this.session));
        }
        finally {
            ShutdownHook hook = this.shutdownHookRef.get();
            if (hook != null) {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
        }
    }

    @Override
    public void clean(String status) {
        String namespace = this.session.getNamespace();
        if (this.configuration.isNamespaceCleanupEnabled()) {
            this.namespaceService.destroy(namespace);
        } else {
            try {
                this.namespaceService.annotate(this.session.getNamespace(), this.annotationProvider.create(this.session.getId(), status));
            }
            catch (Throwable t) {
                this.session.getLogger().warn("Could not annotate namespace: [" + namespace + "] with status: [" + status + "].");
            }
        }
    }

    @Override
    public void display() {
        for (ReplicationController replicationController : ((ReplicationControllerList)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.session.getNamespace())).list()).getItems()) {
            this.session.getLogger().info("Replication controller: [" + replicationController.getMetadata().getName() + "]");
        }
        for (Pod pod : ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).list()).getItems()) {
            this.session.getLogger().info("Pod: [" + pod.getMetadata().getName() + "] Status: [" + pod.getStatus().getPhase() + "]");
        }
        for (Service service : ((ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.session.getNamespace())).list()).getItems()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Service: [").append(service.getMetadata().getName()).append("]").append(" IP: [").append(service.getSpec().getClusterIP()).append("]").append(" Ports: [ ");
            for (ServicePort servicePort : service.getSpec().getPorts()) {
                sb.append(servicePort.getPort()).append(" ");
            }
            sb.append("]");
            this.session.getLogger().info(sb.toString());
        }
    }

    private String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }
}

