/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.install;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.impl.visitor.CompositeVisitor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;

public class DefaultResourceInstaller
implements ResourceInstaller {
    @Inject
    protected Instance<KubernetesClient> client;
    @Inject
    protected Instance<ServiceLoader> serviceLoader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<HasMetadata> install(URL url) {
        ServiceLoader serviceLoader = (ServiceLoader)this.serviceLoader.get();
        KubernetesClient client = (KubernetesClient)this.client.get();
        ArrayList visitors = new ArrayList(serviceLoader.all(Visitor.class));
        CompositeVisitor compositeVisitor = new CompositeVisitor(visitors);
        try (InputStream is = url.openStream();){
            List list = (List)((ListVisitFromServerGetDeleteRecreateWaitApplicable)client.load(is).accept(compositeVisitor)).createOrReplace();
            return list;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }
}

