/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.impl.util.SystemEnvironmentVariables;
import org.arquillian.cube.kubernetes.api.AnnotationProvider;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.DependencyResolver;
import org.arquillian.cube.kubernetes.api.KubernetesResourceLocator;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.api.NamespaceService;
import org.arquillian.cube.kubernetes.api.ResourceInstaller;
import org.arquillian.cube.kubernetes.api.Session;
import org.arquillian.cube.kubernetes.api.SessionCreatedListener;
import org.arquillian.cube.kubernetes.impl.ShutdownHook;
import org.arquillian.cube.kubernetes.impl.utils.ProcessUtil;
import org.jboss.arquillian.core.spi.Validate;

public class SessionManager
implements SessionCreatedListener {
    private final Session session;
    private final KubernetesClient client;
    private final Configuration configuration;
    private final AnnotationProvider annotationProvider;
    private final NamespaceService namespaceService;
    private final KubernetesResourceLocator kubernetesResourceLocator;
    private final DependencyResolver dependencyResolver;
    private final ResourceInstaller resourceInstaller;
    private final List<HasMetadata> resources = new ArrayList<HasMetadata>();
    private final AtomicReference<ShutdownHook> shutdownHookRef = new AtomicReference();

    public SessionManager(Session session, KubernetesClient client, Configuration configuration, AnnotationProvider annotationProvider, NamespaceService namespaceService, KubernetesResourceLocator kubernetesResourceLocator, DependencyResolver dependencyResolver, ResourceInstaller resourceInstaller) {
        Validate.notNull((Object)session, (String)"A Session instance is required.");
        Validate.notNull((Object)client, (String)"A KubernetesClient instance is required.");
        Validate.notNull((Object)configuration, (String)"Configuration is required.");
        Validate.notNull((Object)annotationProvider, (String)"An AnnotationProvider instance is required.");
        Validate.notNull((Object)namespaceService, (String)"A NamespaceService instance is required.");
        Validate.notNull((Object)dependencyResolver, (String)"A DependencyResolver instance is required.");
        Validate.notNull((Object)kubernetesResourceLocator, (String)"A KubernetesResourceLocator instance is required.");
        Validate.notNull((Object)resourceInstaller, (String)"A ResourceInstaller instance is required.");
        this.session = session;
        this.client = client;
        this.configuration = configuration;
        this.annotationProvider = annotationProvider;
        this.namespaceService = namespaceService;
        this.kubernetesResourceLocator = kubernetesResourceLocator;
        this.dependencyResolver = dependencyResolver;
        this.resourceInstaller = resourceInstaller;
    }

    @Override
    public void start() {
        ShutdownHook hook = null;
        Logger log = this.session.getLogger();
        String namespace = this.session.getNamespace();
        log.status("Using Kubernetes at: " + this.client.getMasterUrl());
        log.status("Creating kubernetes resources inside namespace: " + namespace);
        log.info("if you use OpenShift then type this switch namespaces:     oc project " + namespace);
        log.info("if you use kubernetes then type this to switch namespaces: kubectl config set-context `kubectl config current-context` --namespace=" + namespace);
        Map<String, String> namespaceAnnotations = this.annotationProvider.create(this.session.getId(), "RUNNING");
        if (!this.namespaceService.exists(this.session.getNamespace()).booleanValue()) {
            if (this.configuration.isNamespaceLazyCreateEnabled()) {
                this.namespaceService.create(this.session.getNamespace(), namespaceAnnotations);
            } else {
                throw new IllegalStateException("Namespace [" + this.session.getNamespace() + "] doesn't exists");
            }
        }
        hook = new ShutdownHook(new Runnable(){

            @Override
            public void run() {
                SessionManager.this.clean("ABORTED");
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        this.shutdownHookRef.set(hook);
        try {
            List<URL> dependencyUrls;
            URL configUrl = this.configuration.getEnvironmentConfigUrl();
            List<URL> list = dependencyUrls = !this.configuration.getEnvironmentDependencies().isEmpty() ? this.configuration.getEnvironmentDependencies() : this.dependencyResolver.resolve(this.session);
            if (this.configuration.isEnvironmentInitEnabled()) {
                if (this.configuration.getEnvironmentSetupScriptUrl() != null) {
                    this.setupEnvironment();
                }
                for (URL uRL : dependencyUrls) {
                    log.info("Found dependency: " + uRL);
                    this.resources.addAll(this.resourceInstaller.install(uRL));
                }
                if (configUrl == null) {
                    configUrl = this.kubernetesResourceLocator.locate();
                }
                if (configUrl != null) {
                    log.status("Applying kubernetes configuration from: " + configUrl);
                    Throwable throwable = null;
                    try (InputStream is = configUrl.openStream();){
                        this.resources.addAll(this.resourceInstaller.install(configUrl));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                } else {
                    log.warn("Did not find any kubernetes configuration.");
                }
                ArrayList<HasMetadata> resourcesToWait = new ArrayList<HasMetadata>(this.resources);
                for (String service : this.configuration.getWaitForServiceList()) {
                    Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)this.client.endpoints().inNamespace(this.session.getNamespace())).withName(service)).get();
                    if (endpoints == null) continue;
                    resourcesToWait.add((HasMetadata)endpoints);
                }
                if (!resourcesToWait.isEmpty()) {
                    try {
                        this.client.resourceList(resourcesToWait).waitUntilReady(this.configuration.getWaitTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (KubernetesClientTimeoutException kubernetesClientTimeoutException) {
                        log.warn("The are resources in not ready state.");
                        for (HasMetadata r : kubernetesClientTimeoutException.getResourcesNotReady()) {
                            log.error(r.getKind() + " name: " + r.getMetadata().getName() + " namespace:" + r.getMetadata().getNamespace());
                        }
                        throw new IllegalStateException("Environment not initialized in time.", kubernetesClientTimeoutException);
                    }
                }
            }
            this.display();
        }
        catch (Exception e) {
            try {
                this.clean("ERROR");
            }
            catch (Exception me) {
                throw new RuntimeException(e);
            }
            finally {
                if (hook != null) {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.clean(SessionManager.getSessionStatus(this.session));
        }
        finally {
            ShutdownHook hook = this.shutdownHookRef.get();
            if (hook != null) {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(String status) {
        String namespace = this.session.getNamespace();
        try {
            if (this.configuration.isNamespaceCleanupEnabled()) {
                this.resourceInstaller.uninstall(this.resources);
            } else if (this.configuration.isNamespaceDestroyEnabled()) {
                this.namespaceService.destroy(namespace);
            } else {
                try {
                    this.namespaceService.annotate(this.session.getNamespace(), this.annotationProvider.create(this.session.getId(), status));
                }
                catch (Throwable t) {
                    this.session.getLogger().warn("Could not annotate namespace: [" + namespace + "] with status: [" + status + "].");
                }
            }
        }
        finally {
            this.tearDownEnvironment();
        }
    }

    @Override
    public void display() {
        ServiceList serviceList;
        PodList podList;
        ReplicationControllerList replicationControllerList;
        ReplicaSetList replicaSetList = (ReplicaSetList)((NonNamespaceOperation)this.client.extensions().replicaSets().inNamespace(this.session.getNamespace())).list();
        if (replicaSetList.getItems() != null) {
            for (Object replicaSet : replicaSetList.getItems()) {
                this.session.getLogger().info("ReplicaSet: [" + replicaSet.getMetadata().getName() + "]");
            }
        }
        if ((replicationControllerList = (ReplicationControllerList)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.session.getNamespace())).list()).getItems() != null) {
            for (Object replicationController : replicationControllerList.getItems()) {
                this.session.getLogger().info("Replication controller: [" + replicationController.getMetadata().getName() + "]");
            }
        }
        if ((podList = (PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Pod pod : podList.getItems()) {
                this.session.getLogger().info("Pod: [" + pod.getMetadata().getName() + "] Status: [" + pod.getStatus().getPhase() + "]");
            }
        }
        if ((serviceList = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.session.getNamespace())).list()) != null) {
            for (Service service : serviceList.getItems()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Service: [").append(service.getMetadata().getName()).append("]").append(" IP: [").append(service.getSpec().getClusterIP()).append("]").append(" Ports: [ ");
                for (ServicePort servicePort : service.getSpec().getPorts()) {
                    sb.append(servicePort.getPort()).append(" ");
                }
                sb.append("]");
                this.session.getLogger().info(sb.toString());
            }
        }
    }

    private void setupEnvironment() {
        Logger log = this.session.getLogger();
        log.info("Executing environment setup script from:" + this.configuration.getEnvironmentSetupScriptUrl());
        try {
            ProcessUtil.runCommand(log, this.configuration.getEnvironmentSetupScriptUrl(), this.createScriptEnvironment());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void tearDownEnvironment() {
        if (this.configuration.getEnvironmentTeardownScriptUrl() != null) {
            try {
                this.session.getLogger().info("Executing environment teardown script from:" + this.configuration.getEnvironmentTeardownScriptUrl());
                ProcessUtil.runCommand(this.session.getLogger(), this.configuration.getEnvironmentTeardownScriptUrl(), this.createScriptEnvironment());
            }
            catch (IOException ex) {
                this.session.getLogger().warn("Failed to execute teardown script, due to: " + ex.getMessage());
            }
        }
    }

    private Map<String, String> createScriptEnvironment() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.namespace"), this.configuration.getNamespace());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.domain"), this.configuration.getKubernetesDomain());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"kubernetes.master"), this.configuration.getMasterUrl().toString());
        env.put(SystemEnvironmentVariables.propertyToEnvironmentVariableName((String)"docker.registry"), this.configuration.getDockerRegistry());
        return env;
    }

    private static String getSessionStatus(Session session) {
        if (session.getFailed().get() > 0) {
            return "FAILED";
        }
        return "PASSED";
    }
}

