/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.portforward;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.conduits.ReadTimeoutStreamSourceConduit;
import io.undertow.conduits.WriteTimeoutStreamSinkConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.HttpHandler;
import io.undertow.server.OpenListener;
import io.undertow.server.XnioByteBufferPool;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwardServerConnection;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;
import org.xnio.conduits.StreamSinkConduit;
import org.xnio.conduits.StreamSourceConduit;

public class PortForwardOpenListener
implements OpenListener {
    private final ByteBufferPool bufferPool;
    private final int bufferSize;
    private final String urlPath;
    private final int targetPort;
    private final AtomicInteger requestId;
    private volatile OptionMap undertowOptions;
    private ClientConnection masterPortForwardConnection;

    public PortForwardOpenListener(ClientConnection masterPortForwardConnection, String urlPath, int targetPort, AtomicInteger requestId, Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this.masterPortForwardConnection = masterPortForwardConnection;
        this.urlPath = urlPath;
        this.targetPort = targetPort;
        this.requestId = requestId;
        this.undertowOptions = undertowOptions;
        this.bufferPool = new XnioByteBufferPool(pool);
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
    }

    public void handleEvent(StreamConnection channel) {
        try {
            Integer writeTimeout;
            Integer readTimeout = (Integer)channel.getOption(Options.READ_TIMEOUT);
            Integer idleTimeout = (Integer)this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
            if ((readTimeout == null || readTimeout <= 0) && idleTimeout != null) {
                readTimeout = idleTimeout;
            } else if (readTimeout != null && idleTimeout != null && idleTimeout > 0) {
                readTimeout = Math.min(readTimeout, idleTimeout);
            }
            if (readTimeout != null && readTimeout > 0) {
                channel.getSourceChannel().setConduit((StreamSourceConduit)new ReadTimeoutStreamSourceConduit(channel.getSourceChannel().getConduit(), channel, (OpenListener)this));
            }
            if (((writeTimeout = (Integer)channel.getOption(Options.WRITE_TIMEOUT)) == null || writeTimeout <= 0) && idleTimeout != null) {
                writeTimeout = idleTimeout;
            } else if (writeTimeout != null && idleTimeout != null && idleTimeout > 0) {
                writeTimeout = Math.min(writeTimeout, idleTimeout);
            }
            if (writeTimeout != null && writeTimeout > 0) {
                channel.getSinkChannel().setConduit((StreamSinkConduit)new WriteTimeoutStreamSinkConduit(channel.getSinkChannel().getConduit(), channel, (OpenListener)this));
            }
        }
        catch (IOException e) {
            IoUtils.safeClose((Closeable)channel);
            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
        }
        final PortForwardServerConnection connection = new PortForwardServerConnection(channel, this.bufferPool, this.undertowOptions, this.bufferSize);
        connection.getWorker().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    connection.startForwarding(PortForwardOpenListener.this.masterPortForwardConnection, PortForwardOpenListener.this.urlPath, PortForwardOpenListener.this.targetPort, PortForwardOpenListener.this.requestId.getAndIncrement());
                }
                catch (IOException iOException) {
                }
                finally {
                    IoUtils.safeClose((Closeable)((Object)connection));
                }
            }
        });
    }

    public HttpHandler getRootHandler() {
        return null;
    }

    public void setRootHandler(HttpHandler rootHandler) {
    }

    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectorStatistics getConnectorStatistics() {
        return null;
    }
}

