/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.visitor;

import io.fabric8.kubernetes.api.builder.v4_0.Visitor;
import io.fabric8.kubernetes.api.model.v4_0.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v4_0.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ServiceAccountFluent;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import org.arquillian.cube.impl.util.Strings;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class ServiceAccountVisitor
implements Visitor {
    @Inject
    protected Instance<Logger> logger;
    @Inject
    Instance<KubernetesClient> client;
    @Inject
    Instance<Configuration> configuration;

    public void visit(Object element) {
        PodSpecBuilder builder;
        String serviceAccount;
        if (element instanceof PodSpecBuilder && Strings.isNotNullOrEmpty((String)(serviceAccount = (builder = (PodSpecBuilder)element).getServiceAccountName())) && !this.serviceAccountExists(serviceAccount)) {
            try {
                this.createServiceAccount(serviceAccount);
            }
            catch (Throwable t) {
                ((Logger)this.logger.get()).warn("Failed to create ServiceAccount with name:[" + serviceAccount + "].");
            }
        }
    }

    private boolean serviceAccountExists(String serviceAccount) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        return ((Resource)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).withName(serviceAccount)).get() != null;
    }

    private void createServiceAccount(String serviceAccount) {
        KubernetesClient client = (KubernetesClient)this.client.get();
        Configuration configuration = (Configuration)this.configuration.get();
        ((DoneableServiceAccount)((ServiceAccountFluent.MetadataNested)((DoneableServiceAccount)((NonNamespaceOperation)client.serviceAccounts().inNamespace(configuration.getNamespace())).createNew()).withNewMetadata().withName(serviceAccount)).endMetadata()).done();
    }
}

