/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.requirement;

import io.fabric8.kubernetes.clnt.v4_0.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.utils.URLUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.arquillian.cube.kubernetes.impl.ClientConfigBuilder;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import org.arquillian.cube.kubernetes.impl.ExtensionRegistrar;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class KubernetesRequirement
implements Constraint<RequiresKubernetes> {
    public void check(RequiresKubernetes context) throws UnsatisfiedRequirementException {
        List<String> extension = Collections.singletonList("kubernetes");
        DefaultConfiguration config = new ExtensionRegistrar().loadExtension(extension);
        DefaultKubernetesClient client = new DefaultKubernetesClient(new ClientConfigBuilder().configuration(config).build());
        OkHttpClient httpClient = (OkHttpClient)client.adapt(OkHttpClient.class);
        Request versionRequest = new Request.Builder().get().url(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"})).build();
        try {
            Response response = httpClient.newCall(versionRequest).execute();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify kubernetes version, due to: [" + response.message() + "]");
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedRequirementException("Error while checking kubernetes version: [" + e.getMessage() + "]");
        }
    }
}

