package org.arquillian.cube.kubernetes.impl;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.List;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.net.URL;
import java.util.AbstractList;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.io.IOException;
import io.fabric8.kubernetes.api.builder.v4_0.Fluent;

public interface DefaultConfigurationFluent<A extends DefaultConfigurationFluent<A>> extends Fluent<A>{


    public String getSessionId();    public A withSessionId( String sessionId);    public String getNamespace();    public A withNamespace( String namespace);    public URL getMasterUrl();    public A withMasterUrl( URL masterUrl);    public A addToScriptEnvironmentVariables( String key,  String value);    public A addToScriptEnvironmentVariables( Map<String, String> map);    public A removeFromScriptEnvironmentVariables( String key);    public A removeFromScriptEnvironmentVariables( Map<String, String> map);    public Map<String, String> getScriptEnvironmentVariables();    public A withScriptEnvironmentVariables( Map<String, String> scriptEnvironmentVariables);    public URL getEnvironmentSetupScriptUrl();    public A withEnvironmentSetupScriptUrl( URL environmentSetupScriptUrl);    public URL getEnvironmentTeardownScriptUrl();    public A withEnvironmentTeardownScriptUrl( URL environmentTeardownScriptUrl);    public URL getEnvironmentConfigUrl();    public A withEnvironmentConfigUrl( URL environmentConfigUrl);    public A addToEnvironmentDependencies( URL ...items);    public A removeFromEnvironmentDependencies( URL ...items);    public List<URL> getEnvironmentDependencies();    public A withEnvironmentDependencies( List<URL> environmentDependencies);    public A withEnvironmentDependencies( URL ...environmentDependencies);    public boolean isNamespaceLazyCreateEnabled();    public A withNamespaceLazyCreateEnabled( boolean namespaceLazyCreateEnabled);    public boolean isNamespaceCleanupEnabled();    public A withNamespaceCleanupEnabled( boolean namespaceCleanupEnabled);    public long getNamespaceCleanupTimeout();    public A withNamespaceCleanupTimeout( long namespaceCleanupTimeout);    public boolean isNamespaceCleanupConfirmationEnabled();    public A withNamespaceCleanupConfirmationEnabled( boolean namespaceCleanupConfirmationEnabled);    public boolean isNamespaceUseCurrentEnabled();    public A withNamespaceUseCurrentEnabled( boolean namespaceUseCurrentEnabled);    public boolean isNamespaceDestroyEnabled();    public A withNamespaceDestroyEnabled( boolean namespaceDestroyEnabled);    public boolean isNamespaceDestroyConfirmationEnabled();    public A withNamespaceDestroyConfirmationEnabled( boolean namespaceDestroyConfirmationEnabled);    public long getNamespaceDestroyTimeout();    public A withNamespaceDestroyTimeout( long namespaceDestroyTimeout);    public boolean isWaitEnabled();    public A withWaitEnabled( boolean waitEnabled);    public long getWaitTimeout();    public A withWaitTimeout( long waitTimeout);    public long getWaitPollInterval();    public A withWaitPollInterval( long waitPollInterval);    public A addToWaitForServiceList( String ...items);    public A removeFromWaitForServiceList( String ...items);    public List<String> getWaitForServiceList();    public A withWaitForServiceList( List<String> waitForServiceList);    public A withWaitForServiceList( String ...waitForServiceList);    public boolean isAnsiLoggerEnabled();    public A withAnsiLoggerEnabled( boolean ansiLoggerEnabled);    public boolean isEnvironmentInitEnabled();    public A withEnvironmentInitEnabled( boolean environmentInitEnabled);    public boolean isLogCopyEnabled();    public A withLogCopyEnabled( boolean logCopyEnabled);    public String getLogPath();    public A withLogPath( String logPath);    public String getKubernetesDomain();    public A withKubernetesDomain( String kubernetesDomain);    public String getDockerRegistry();    public A withDockerRegistry( String dockerRegistry);    public String getUsername();    public A withUsername( String username);    public String getPassword();    public A withPassword( String password);    public String getApiVersion();    public A withApiVersion( String apiVersion);    public boolean isTrustCerts();    public A withTrustCerts( boolean trustCerts);    public boolean isFmpBuildEnabled();    public A withFmpBuildEnabled( boolean fmpBuildEnabled);    public boolean isFmpBuildForMavenDisable();    public A withFmpBuildForMavenDisable( boolean fmpBuildForMavenDisable);    public boolean isFmpDebugOutput();    public A withFmpDebugOutput( boolean fmpDebugOutput);    public boolean isFmpLogsEnabled();    public A withFmpLogsEnabled( boolean fmpLogsEnabled);    public String getFmpPomPath();    public A withFmpPomPath( String fmpPomPath);    public A addToFmpProfiles( String ...items);    public A removeFromFmpProfiles( String ...items);    public List<String> getFmpProfiles();    public A withFmpProfiles( List<String> fmpProfiles);    public A withFmpProfiles( String ...fmpProfiles);    public A addToFmpSystemProperties( String ...items);    public A removeFromFmpSystemProperties( String ...items);    public List<String> getFmpSystemProperties();    public A withFmpSystemProperties( List<String> fmpSystemProperties);    public A withFmpSystemProperties( String ...fmpSystemProperties);    public String getFmpBuildOptions();    public A withFmpBuildOptions( String fmpBuildOptions);    public String getToken();    public A withToken( String token);

}
