/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import io.fabric8.kubernetes.api.model.v4_0.EndpointSubset;
import io.fabric8.kubernetes.api.model.v4_0.Endpoints;
import io.fabric8.kubernetes.api.model.v4_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_0.Pod;
import io.fabric8.kubernetes.api.model.v4_0.PodList;
import io.fabric8.kubernetes.api.model.v4_0.ReplicationController;
import io.fabric8.kubernetes.api.model.v4_0.Service;
import io.fabric8.kubernetes.api.model.v4_0.ServiceList;
import io.fabric8.kubernetes.api.model.v4_0.ServicePort;
import io.fabric8.kubernetes.api.model.v4_0.apps.Deployment;
import io.fabric8.kubernetes.clnt.v4_0.Config;
import io.fabric8.kubernetes.clnt.v4_0.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_0.dsl.CascadingDeletable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import io.fabric8.kubernetes.clnt.v4_0.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_0.internal.readiness.Readiness;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.arquillian.cube.kubernetes.impl.KubernetesAssistantDefaultResourceLocator;
import org.arquillian.cube.kubernetes.impl.portforward.PortForwarder;
import org.arquillian.cube.kubernetes.impl.utils.ResourceFilter;
import org.awaitility.Awaitility;

public class KubernetesAssistant {
    private static final Logger log = Logger.getLogger(KubernetesAssistant.class.getName());
    protected KubernetesClient client;
    protected String namespace;
    protected String applicationName;
    private KubernetesAssistantDefaultResourceLocator kubernetesAssistantDefaultResourcesLocator;
    private Map<String, List<HasMetadata>> created = new LinkedHashMap<String, List<HasMetadata>>();

    public KubernetesAssistant(KubernetesClient client, String namespace) {
        this.client = client;
        this.namespace = namespace;
        this.kubernetesAssistantDefaultResourcesLocator = new KubernetesAssistantDefaultResourceLocator();
    }

    public String deployApplication() throws IOException {
        this.deployApplication((String)null);
        return this.applicationName;
    }

    public void deployApplication(String applicationName) throws IOException {
        Optional<URL> defaultFileOptional = this.kubernetesAssistantDefaultResourcesLocator.locate();
        if (defaultFileOptional.isPresent()) {
            this.deployApplication(applicationName, defaultFileOptional.get());
        } else {
            log.warning("No default Kubernetes resources found at default locations.");
        }
    }

    public void deployApplication(String applicationName, String ... classpathLocations) throws IOException {
        List<URL> classpathElements = Arrays.stream(classpathLocations).map(classpath -> Thread.currentThread().getContextClassLoader().getResource((String)classpath)).collect(Collectors.toList());
        this.deployApplication(applicationName, classpathElements.toArray(new URL[classpathElements.size()]));
    }

    public String deployApplication(URL ... urls) throws IOException {
        this.deployApplication((String)null, urls);
        return this.applicationName;
    }

    public void deployApplication(String applicationName, URL ... urls) throws IOException {
        this.applicationName = applicationName;
        for (URL url : urls) {
            try (InputStream inputStream = url.openStream();){
                this.deploy(inputStream);
            }
        }
    }

    public void deployAll(String applicationName, String pattern) {
        this.applicationName = applicationName;
        FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(new String[0]);
        fastClasspathScanner.matchFilenamePattern(pattern, (relativePath, inputStream, lengthBytes) -> this.deploy(inputStream)).scan();
    }

    public String deployAll(String pattern) {
        FastClasspathScanner fastClasspathScanner = new FastClasspathScanner(new String[0]);
        fastClasspathScanner.matchFilenamePattern(pattern, (relativePath, inputStream, lengthBytes) -> {
            this.deploy(inputStream);
            inputStream.close();
        }).scan();
        return this.applicationName;
    }

    public String deployAll(Path directory) throws IOException {
        this.deployAll(null, directory);
        return this.applicationName;
    }

    public void deployAll(String applicationName, Path directory) throws IOException {
        this.applicationName = applicationName;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s should be a directory", directory));
        }
        Files.list(directory).filter(ResourceFilter::filterKubernetesResource).map(p -> {
            try {
                return Files.newInputStream(p, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(is -> {
            try {
                this.deploy((InputStream)is);
                is.close();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    public void deploy(InputStream inputStream) throws IOException {
        List<? extends HasMetadata> entities = this.deploy("application", inputStream);
        if (this.applicationName == null) {
            Optional<String> deployment = entities.stream().filter(hm -> hm instanceof Deployment).map(hm -> (Deployment)hm).map(rc -> rc.getMetadata().getName()).findFirst();
            deployment.ifPresent(name -> {
                this.applicationName = name;
            });
        }
    }

    protected List<? extends HasMetadata> deploy(String name, InputStream element) {
        ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable declarations = this.client.load(element);
        List entities = (List)declarations.createOrReplace();
        this.created.merge(name, entities, (list1, list2) -> Stream.of(list1, list2).flatMap(Collection::stream).collect(Collectors.toList()));
        log.info(String.format("%s deployed, %s object(s) created.", name, entities.size()));
        return entities;
    }

    public Optional<URL> getServiceUrl(String name) {
        Service service = (Service)((Resource)((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).withName(name)).get();
        return service != null ? this.createUrlForService(service) : Optional.empty();
    }

    public Optional<URL> getServiceUrl() {
        Optional optionalService = ((ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.namespace)).list()).getItems().stream().findFirst();
        return optionalService.map(this::createUrlForService).orElse(Optional.empty());
    }

    private Optional<URL> createUrlForService(Service service) {
        String scheme = service.getMetadata() != null && service.getMetadata().getAnnotations() != null ? (String)service.getMetadata().getAnnotations().get("api.service.kubernetes.io/scheme") : "http";
        String path = service.getMetadata() != null && service.getMetadata().getAnnotations() != null ? (String)service.getMetadata().getAnnotations().get("api.service.kubernetes.io/path") : "/";
        int port = this.resolvePort(service);
        try {
            if (port > 0) {
                return Optional.of(new URL(scheme, "127.0.0.1", port, path));
            }
            return Optional.of(new URL(scheme, "127.0.0.1", path));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot resolve URL for service: [" + service.getMetadata().getName() + "] in namespace:[" + this.namespace + "].");
        }
    }

    private int resolvePort(Service service) {
        Pod pod = this.getRandomPod(this.client, service.getMetadata().getName(), this.namespace);
        ServicePort servicePort = service.getSpec() != null && service.getSpec().getPorts() != null ? (ServicePort)service.getSpec().getPorts().get(0) : null;
        int containerPort = servicePort != null ? servicePort.getTargetPort().getIntVal() : 0;
        return this.portForward(pod.getMetadata().getName(), containerPort, this.namespace);
    }

    private int portForward(String podName, int targetPort, String namespace) {
        return this.portForward(podName, KubernetesAssistant.findRandomFreeLocalPort(), targetPort, namespace);
    }

    private int portForward(String podName, int sourcePort, int targetPort, String namespace) {
        try {
            Config build = ((ConfigBuilder)new ConfigBuilder(this.client.getConfiguration()).withNamespace(namespace)).build();
            PortForwarder portForwarder = new PortForwarder(build, podName);
            portForwarder.forwardPort(sourcePort, targetPort);
            return sourcePort;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findRandomFreeLocalPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Pod getRandomPod(KubernetesClient client, String name, String namespace) {
        Endpoints endpoints = (Endpoints)((Resource)((NonNamespaceOperation)client.endpoints().inNamespace(namespace)).withName(name)).get();
        ArrayList pods = new ArrayList();
        if (endpoints != null) {
            for (EndpointSubset subset : endpoints.getSubsets()) {
                subset.getAddresses().stream().filter(address -> address.getTargetRef() != null && "Pod".equals(address.getTargetRef().getKind())).forEach(address -> {
                    String pod = address.getTargetRef().getName();
                    if (pod != null && !pod.isEmpty()) {
                        pods.add(pod);
                    }
                });
            }
        }
        if (pods.isEmpty()) {
            return null;
        }
        String chosen = (String)pods.get(new Random().nextInt(pods.size()));
        return (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(chosen)).get();
    }

    public void cleanup() {
        ArrayList<String> keys = new ArrayList<String>(this.created.keySet());
        keys.sort(String::compareTo);
        for (String key : keys) {
            this.created.remove(key).stream().sorted(Comparator.comparing(HasMetadata::getKind)).forEach(metadata -> {
                log.info(String.format("Deleting %s : %s", key, metadata.getKind()));
                this.deleteWithRetries((HasMetadata)metadata);
            });
        }
    }

    private void deleteWithRetries(HasMetadata metadata) {
        int retryCounter = 0;
        boolean deleteUnsucessful = true;
        do {
            ++retryCounter;
            try {
                deleteUnsucessful = (Boolean)((CascadingDeletable)this.client.resource(metadata).withGracePeriod(0L)).delete();
            }
            catch (KubernetesClientException e) {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interrupted) {
                    throw new RuntimeException(interrupted);
                }
                e.printStackTrace();
                log.info(String.format("Error deleting resource %s %s retrying #%s ", metadata.getKind(), metadata.getMetadata().getName(), retryCounter));
            }
        } while (retryCounter < 3 && deleteUnsucessful);
        if (deleteUnsucessful) {
            throw new RuntimeException("Unable to delete " + metadata);
        }
    }

    public void awaitApplicationReadinessOrFail() {
        this.awaitApplicationReadinessOrFail(this.applicationName);
    }

    public void awaitApplicationReadinessOrFail(String applicationName) {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> ((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.namespace)).withName(applicationName)).isReady());
    }

    public String project() {
        return this.namespace;
    }

    public void awaitPodReadinessOrFail(Predicate<Pod> filter) {
        Awaitility.await().atMost(5L, TimeUnit.MINUTES).until(() -> {
            List list = ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).list()).getItems();
            return list.stream().filter(filter).filter(Readiness::isPodReady).collect(Collectors.toList()).size() >= 1;
        });
    }

    public void scale(int replicas) {
        this.scale(this.applicationName, replicas);
    }

    public void scale(String applicationName, int replicas) {
        ReplicationController replicationController = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.namespace)).withName(applicationName)).scale(replicas);
        int availableReplicas = replicationController.getStatus().getAvailableReplicas();
        log.info(String.format("Scaling replicas from %d to %d for application %s.", availableReplicas, replicas, applicationName));
        this.awaitApplicationReadinessOrFail(applicationName);
    }

    protected List<Pod> getPods(String label) {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.namespace)).withLabel(label, this.applicationName)).list()).getItems();
    }

    public ReplicationController replicationController() {
        return (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.namespace)).withName(this.applicationName)).get();
    }
}

