/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.utils;

import java.util.ArrayList;
import java.util.Arrays;

public class SystemPropertyResolver {
    public String resolveValue(String property) {
        PropertyValueTuple tuple = new PropertyValueTuple(property).invoke();
        String propertyValue = System.getProperty(tuple.getPropertyName());
        if (propertyValue == null) {
            propertyValue = System.getenv(tuple.getPropertyName());
        }
        if (propertyValue == null) {
            propertyValue = tuple.getDefaultValue();
        }
        if (propertyValue == null) {
            throw new RuntimeException("Could not resolve property \"" + tuple.getPropertyName() + "\" in the system properties or environment variables and no default value is supplied");
        }
        return propertyValue;
    }

    public boolean propertyDefined(String property) {
        String propertyValue = System.getProperty(property);
        if (propertyValue == null) {
            propertyValue = System.getenv(property);
        }
        return propertyValue != null;
    }

    private class PropertyValueTuple {
        private String propertyName;
        private String defaultValue;

        PropertyValueTuple(String property) {
            this.propertyName = property;
            this.defaultValue = null;
        }

        String getPropertyName() {
            return this.propertyName;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        PropertyValueTuple invoke() {
            if (this.propertyName.contains(":")) {
                String[] kv = this.splitWorker(this.propertyName, ':', true);
                this.propertyName = kv[0];
                if (kv.length > 1) {
                    this.defaultValue = String.join((CharSequence)":", Arrays.copyOfRange(kv, 1, kv.length));
                }
            }
            return this;
        }

        private String[] splitWorker(String str, char separator, boolean preserveAllTokens) {
            if (str == null) {
                return null;
            }
            int len = str.length();
            if (len == 0) {
                return new String[0];
            }
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int start = 0;
            boolean match = false;
            boolean lastMatch = false;
            while (i < len) {
                if (str.charAt(i) == separator) {
                    if (match || preserveAllTokens) {
                        list.add(str.substring(start, i));
                        match = false;
                        lastMatch = true;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
            if (match || preserveAllTokens && lastMatch) {
                list.add(str.substring(start, i));
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

