/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.restassured;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.restassured.RestAssuredConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStopping;

public class RestAssuredCustomizer {
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    @ApplicationScoped
    InstanceProducer<RequestSpecBuilder> requestSpecBuilderInstanceProducer;

    public void configure(@Observes RestAssuredConfiguration restAssuredConfiguration) {
        CubeOpenShiftConfiguration openShiftConfiguration = (CubeOpenShiftConfiguration)this.configurationInstance.get();
        RequestSpecBuilder requestSpecBuilder = new RequestSpecBuilder();
        this.configureRequestSpecBuilder(restAssuredConfiguration, openShiftConfiguration, requestSpecBuilder);
        this.requestSpecBuilderInstanceProducer.set((Object)requestSpecBuilder);
    }

    void configureRequestSpecBuilder(@Observes RestAssuredConfiguration restAssuredConfiguration, CubeOpenShiftConfiguration openShiftConfiguration, RequestSpecBuilder requestSpecBuilder) {
        if (restAssuredConfiguration.isBaseUriSet()) {
            requestSpecBuilder.setBaseUri(restAssuredConfiguration.getBaseUri());
        } else {
            requestSpecBuilder.setBaseUri(restAssuredConfiguration.getSchema() + "://" + openShiftConfiguration.getMasterUrl());
        }
        if (restAssuredConfiguration.isPortSet()) {
            requestSpecBuilder.setPort(restAssuredConfiguration.getPort());
        } else {
            requestSpecBuilder.setPort(openShiftConfiguration.getOpenshiftRouterHttpPort());
        }
        if (restAssuredConfiguration.isBasePathSet()) {
            requestSpecBuilder.setBasePath(restAssuredConfiguration.getBasePath());
        }
        if (restAssuredConfiguration.isAuthenticationSchemeSet()) {
            requestSpecBuilder.setAuth(restAssuredConfiguration.getAuthenticationScheme());
        }
        if (restAssuredConfiguration.isUseRelaxedHttpsValidationSet()) {
            if (restAssuredConfiguration.isUseRelaxedHttpsValidationInAllProtocols()) {
                requestSpecBuilder.setRelaxedHTTPSValidation();
            } else {
                requestSpecBuilder.setRelaxedHTTPSValidation(restAssuredConfiguration.getUseRelaxedHttpsValidation());
            }
        }
    }

    public void resetRestAssuredConfiguration(@Observes ManagerStopping event) {
        RestAssured.reset();
    }
}

