/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.restassured;

import io.restassured.builder.RequestSpecBuilder;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.OpenShiftRouteLocator;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.restassured.RestAssuredConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class RequestSpecBuilderResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<OpenShiftClient> clientInstance;
    @Inject
    private Instance<Configuration> configurationInstance;
    @Inject
    private Instance<RestAssuredConfiguration> restAssuredConfigurationInstance;
    @Inject
    private Instance<RequestSpecBuilder> requestSpecBuilderInstance;

    public boolean canProvide(Class<?> type) {
        return RequestSpecBuilder.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        try {
            OpenShiftRouteLocator openShiftRouteLocator = new OpenShiftRouteLocator(this.clientInstance, this.configurationInstance);
            RestAssuredConfiguration restAssuredConfiguration = (RestAssuredConfiguration)this.restAssuredConfigurationInstance.get();
            String baseUri = restAssuredConfiguration.getBaseUri();
            if (baseUri != null && !baseUri.isEmpty()) {
                return this.configureRequestSpecBuilder(openShiftRouteLocator.getRoute(new URL(baseUri)));
            }
            return this.configureRequestSpecBuilder(openShiftRouteLocator.getRoute());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private RequestSpecBuilder configureRequestSpecBuilder(URL route) {
        RequestSpecBuilder requestSpecBuilder = (RequestSpecBuilder)this.requestSpecBuilderInstance.get();
        if (requestSpecBuilder == null) {
            throw new IllegalStateException("RequestSpecBuilder was not found.");
        }
        requestSpecBuilder.setBaseUri(route.getProtocol() + "://" + route.getHost());
        requestSpecBuilder.setPort(route.getPort());
        requestSpecBuilder.setBasePath(route.getPath());
        ResourceUtil.awaitRoute((URL)route, (int[])new int[0]);
        return requestSpecBuilder;
    }
}

