/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.openshift.client.OpenShiftConfig;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;

public class OpenShiftClientCreator {
    @Inject
    @ApplicationScoped
    private InstanceProducer<OpenShiftClient> openShiftClientProducer;

    public void createClient(@Observes CubeOpenShiftConfiguration cubeConfiguration) {
        System.setProperty("KUBERNETES_TRUST_CERT", "true");
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(new Config()).withMasterUrl(cubeConfiguration.getOriginServer())).withNamespace(cubeConfiguration.getNamespace())).withTrustCerts(true)).build();
        if (config.getNoProxy() == null) {
            config.setNoProxy(new String[0]);
        }
        this.openShiftClientProducer.set((Object)this.createClient(OpenShiftConfig.wrap((Config)config), cubeConfiguration.getNamespace(), cubeConfiguration.shouldKeepAliveGitServer()));
    }

    public void clean(@Observes AfterSuite event, OpenShiftClient client) throws Exception {
        client.shutdown();
    }

    public OpenShiftClient createClient(OpenShiftConfig openShiftConfig, String namespace, boolean keepAliveGitServer) {
        return new OpenShiftClient(openShiftConfig, namespace, keepAliveGitServer);
    }
}

