/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.spdy;

import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdySetting;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.StreamConnection;

public class SpdyChannelWithoutFlowControl
extends SpdyChannel {
    private int initialWindowSize;
    private int currentWindowSize;

    public SpdyChannelWithoutFlowControl(StreamConnection connectedStreamChannel, Pool<ByteBuffer> bufferPool, Pooled<ByteBuffer> data, Pool<ByteBuffer> heapBufferPool, boolean clientSide) {
        super(connectedStreamChannel, bufferPool, data, heapBufferPool, clientSide);
        this.currentWindowSize = this.initialWindowSize = this.getInitialWindowSize();
    }

    synchronized int grabFlowControlBytes(int bytesToGrab) {
        this.currentWindowSize += this.initialWindowSize;
        this.updateSettings(Collections.singletonList(new SpdySetting(0, 7, this.currentWindowSize)));
        return super.grabFlowControlBytes(bytesToGrab);
    }
}

