/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.undertow.UndertowMessages;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.spdy.SpdyChannel;
import io.undertow.protocols.spdy.SpdyStreamStreamSinkChannel;
import io.undertow.server.AbstractServerConnection;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.SSLSessionInfo;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.StringReadChannelListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.arquillian.cube.openshift.impl.client.ChannelUtils;
import org.xnio.ChainedChannelListener;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.channels.CloseableChannel;
import org.xnio.conduits.StreamSinkConduit;

public class PortForwardServerConnection
extends AbstractServerConnection {
    private final CountDownLatch errorComplete = new CountDownLatch(1);
    private final CountDownLatch requestComplete = new CountDownLatch(1);

    public PortForwardServerConnection(StreamConnection channel, ByteBufferPool bufferPool, OptionMap undertowOptions, int bufferSize) {
        super(channel, bufferPool, null, undertowOptions, bufferSize);
    }

    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        throw new UnsupportedOperationException("PortForward connection does not support HTTP!");
    }

    public void terminateRequestChannel(HttpServerExchange exchange) {
        throw new UnsupportedOperationException("PortForward connection does not support HTTP!");
    }

    public SSLSessionInfo getSslSessionInfo() {
        return null;
    }

    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        throw new UnsupportedOperationException("PortForward connection does not support SSL!");
    }

    protected StreamConnection upgradeChannel() {
        throw UndertowMessages.MESSAGES.upgradeNotSupported();
    }

    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        return conduit;
    }

    protected boolean isUpgradeSupported() {
        return false;
    }

    protected void exchangeComplete(HttpServerExchange exchange) {
    }

    public String getTransportProtocol() {
        return "raw";
    }

    protected boolean isConnectSupported() {
        return false;
    }

    public boolean isContinueResponseSupported() {
        return false;
    }

    protected void setConnectListener(HttpUpgradeListener connectListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startForwarding(ClientConnection clientConnection, String urlPath, int targetPort, int requestId) throws IOException {
        try {
            this.openErrorStream(clientConnection, urlPath, targetPort, requestId);
            this.openDataStream(clientConnection, urlPath, targetPort, requestId);
            try {
                this.requestComplete.await();
                this.errorComplete.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IoUtils.safeClose((Closeable)((Object)this));
        }
    }

    private void openErrorStream(ClientConnection clientConnection, String urlPath, int targetPort, int requestId) throws IOException {
        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(urlPath);
        request.getRequestHeaders().put(new HttpString("streamType"), "error").put(new HttpString("port"), (long)targetPort).put(new HttpString("requestID"), (long)requestId);
        final CountDownLatch latch = new CountDownLatch(1);
        final IOException[] holder = new IOException[1];
        clientConnection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

            public void failed(IOException e) {
                holder[0] = e;
                latch.countDown();
            }

            public void completed(ClientExchange result) {
                latch.countDown();
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(ClientExchange result) {
                        new StringReadChannelListener(PortForwardServerConnection.this.getByteBufferPool()){

                            protected void stringDone(String string) {
                                PortForwardServerConnection.this.setError(string);
                            }

                            protected void error(IOException e) {
                                PortForwardServerConnection.this.setError(e.getMessage());
                            }
                        }.setup(result.getResponseChannel());
                    }

                    public void failed(IOException e) {
                        PortForwardServerConnection.this.setError(e.getMessage());
                    }
                });
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (holder[0] != null) {
            throw holder[0];
        }
    }

    private void openDataStream(ClientConnection clientConnection, String urlPath, int targetPort, int requestId) throws IOException {
        ClientRequest request = new ClientRequest().setMethod(Methods.POST).setPath(urlPath);
        request.getRequestHeaders().put(new HttpString("streamType"), "data").put(new HttpString("port"), (long)targetPort).put(new HttpString("requestID"), (long)requestId);
        final CountDownLatch latch = new CountDownLatch(1);
        final IOException[] holder = new IOException[1];
        final Timer timer = new Timer("SPDY Keep Alive", true);
        this.getChannel().getCloseSetter().set((ChannelListener)new ChainedChannelListener(new ChannelListener[]{new CancelTimerChannelListener(timer), new LatchReleaseChannelListener(this.requestComplete)}));
        clientConnection.sendRequest(request, (ClientCallback)new ClientCallback<ClientExchange>(){

            public void failed(IOException e) {
                holder[0] = e;
                latch.countDown();
            }

            public void completed(ClientExchange result) {
                latch.countDown();
                result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(){

                    public void completed(final ClientExchange result) {
                        result.getResponseChannel().getCloseSetter().set((ChannelListener)new LatchReleaseChannelListener(PortForwardServerConnection.this.requestComplete));
                        PortForwardServerConnection.this.getIoThread().execute(new Runnable(){

                            @Override
                            public void run() {
                                ChannelUtils.initiateTransfer(Long.MAX_VALUE, result.getResponseChannel(), PortForwardServerConnection.this.getChannel().getSinkChannel(), (Pool<ByteBuffer>)PortForwardServerConnection.this.getBufferPool());
                            }
                        });
                    }

                    public void failed(IOException e) {
                        PortForwardServerConnection.this.requestComplete.countDown();
                    }
                });
                ChannelUtils.initiateTransfer(Long.MAX_VALUE, PortForwardServerConnection.this.getChannel().getSourceChannel(), result.getRequestChannel(), (Pool<ByteBuffer>)PortForwardServerConnection.this.getBufferPool());
                timer.scheduleAtFixedRate((TimerTask)new PingSpdyStream((SpdyStreamStreamSinkChannel)result.getRequestChannel()), 15000L, 15000L);
                try {
                    PortForwardServerConnection.this.requestComplete.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (holder[0] != null) {
            throw holder[0];
        }
    }

    private void setError(String error) {
        if (error != null && !error.trim().equals("")) {
            System.err.println("Port forwarding error: " + error);
        }
        this.errorComplete.countDown();
    }

    private static final class LatchReleaseChannelListener
    implements ChannelListener<CloseableChannel> {
        private final CountDownLatch latch;

        private LatchReleaseChannelListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void handleEvent(CloseableChannel channel) {
            this.latch.countDown();
        }
    }

    private static final class CancelTimerChannelListener
    implements ChannelListener<CloseableChannel> {
        private final Timer timer;

        private CancelTimerChannelListener(Timer timer) {
            this.timer = timer;
        }

        public void handleEvent(CloseableChannel channel) {
            this.timer.cancel();
        }
    }

    private final class PingSpdyStream
    extends TimerTask {
        private final SpdyStreamStreamSinkChannel stream;

        private PingSpdyStream(SpdyStreamStreamSinkChannel stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            PortForwardServerConnection.this.getWorker().execute(new Runnable(){

                @Override
                public void run() {
                    if (PingSpdyStream.this.stream.isOpen()) {
                        ((SpdyChannel)PingSpdyStream.this.stream.getChannel()).sendPing(PingSpdyStream.this.stream.getStreamId());
                    }
                }
            });
        }
    }
}

