/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.model;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.spi.BaseCube;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeControlException;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.HasPortBindings;

public class ServiceCube
extends BaseCube<Void> {
    private String id;
    private Service resource;
    private Cube.State state;
    private CubeOpenShiftConfiguration configuration;
    private OpenShiftClient client;
    private final PortBindings portBindings;

    public ServiceCube(Service resource, OpenShiftClient client, CubeOpenShiftConfiguration configuration) {
        this.id = resource.getMetadata().getName();
        this.resource = resource;
        this.client = client;
        this.configuration = configuration;
        this.portBindings = new PortBindings();
        this.addDefaultMetadata();
    }

    private void addDefaultMetadata() {
        this.addMetadata(HasPortBindings.class, (CubeMetadata)this.portBindings);
    }

    public Cube.State state() {
        return this.state;
    }

    public String getId() {
        return this.id;
    }

    public void create() throws CubeControlException {
        this.state = Cube.State.CREATED;
    }

    public void start() throws CubeControlException {
        try {
            this.resource = this.client.create(this.resource);
            this.portBindings.serviceStarted();
            this.state = Cube.State.STARTED;
        }
        catch (Exception e) {
            this.state = Cube.State.START_FAILED;
            throw CubeControlException.failedStart((String)this.getId(), (Throwable)e);
        }
    }

    public void stop() throws CubeControlException {
        try {
            this.client.destroy(this.resource);
            this.state = Cube.State.STOPPED;
        }
        catch (Exception e) {
            this.state = Cube.State.STOP_FAILED;
            throw CubeControlException.failedStop((String)this.getId(), (Throwable)e);
        }
    }

    public void destroy() throws CubeControlException {
        this.state = Cube.State.DESTROYED;
    }

    public boolean isRunningOnRemote() {
        return this.state == Cube.State.STARTED;
    }

    public void changeToPreRunning() {
    }

    public Binding bindings() {
        return ResourceUtil.toBinding(this.resource);
    }

    public Binding configuredBindings() {
        return ResourceUtil.toBinding(this.resource);
    }

    public Void configuration() {
        return null;
    }

    private final class PortBindings
    implements HasPortBindings {
        private final Map<Integer, HasPortBindings.PortAddress> mappedPorts = new HashMap<Integer, HasPortBindings.PortAddress>();
        private final Set<Integer> containerPorts = new LinkedHashSet<Integer>();
        private String containerIP;

        public PortBindings() {
            for (ServicePort servicePort : ServiceCube.this.resource.getSpec().getPorts()) {
                int port = servicePort.getPort();
                Integer nodePort = servicePort.getNodePort();
                this.containerPorts.add(port);
                if (nodePort == null) continue;
                this.mappedPorts.put(port, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(this.containerIP, nodePort.intValue()));
            }
        }

        public boolean isBound() {
            return ServiceCube.this.state == Cube.State.STARTED;
        }

        public synchronized String getContainerIP() {
            return this.containerIP;
        }

        public String getInternalIP() {
            return null;
        }

        public Set<Integer> getContainerPorts() {
            return Collections.unmodifiableSet(this.containerPorts);
        }

        public Set<Integer> getBoundPorts() {
            return Collections.unmodifiableSet(this.containerPorts);
        }

        public synchronized HasPortBindings.PortAddress getMappedAddress(int targetPort) {
            if (this.mappedPorts.containsKey(targetPort)) {
                return this.mappedPorts.get(targetPort);
            }
            return null;
        }

        public InetAddress getPortForwardBindAddress() {
            return null;
        }

        private synchronized void serviceStarted() throws Exception {
            this.containerIP = ServiceCube.this.resource.getSpec().getPortalIP();
            for (ServicePort servicePort : ServiceCube.this.resource.getSpec().getPorts()) {
                int port = servicePort.getPort();
                Integer nodePort = servicePort.getNodePort();
                this.containerPorts.add(port);
                if (nodePort == null) continue;
                this.mappedPorts.put(port, (HasPortBindings.PortAddress)new HasPortBindings.PortAddressImpl(this.containerIP, nodePort.intValue()));
            }
        }
    }
}

