/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.impl.util.ConfigUtil;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfigurationBuilder;

public class CubeOpenShiftConfiguration {
    private static final Config FALLBACK_CONFIG = new ConfigBuilder().build();
    private static final String ORIGIN_SERVER = "originServer";
    private static final String MASTER_URL = "master.url";
    private static final String NAMESPACE = "namespace";
    private static final String KEEP_ALIVE_GIT_SERVER = "keepAliveGitServer";
    private static final String DEFINITIONS_FILE = "definitionsFile";
    private static final String DEFINITIONS = "definitions";
    private static final String AUTO_START_CONTAINERS = "autoStartContainers";
    private static final String PROXIED_CONTAINER_PORTS = "proxiedContainerPorts";
    private static final String PORT_FORWARDER_BIND_ADDRESS = "portForwardBindAddress";
    private final String originServer;
    private final String namespace;
    private final boolean keepAliveGitServer;
    private final String definitions;
    private final String definitionsFile;
    private final String[] autoStartContainers;
    private final Set<String> proxiedContainerPorts;
    private final String portForwardBindAddress;

    public CubeOpenShiftConfiguration(String originServer, String namespace, boolean keepAliveGitServer, String definitions, String definitionsFile, String[] autoStartContainers, Set<String> proxiedContainerPorts, String portForwardBindAddress) {
        this.originServer = originServer;
        this.namespace = namespace;
        this.keepAliveGitServer = keepAliveGitServer;
        this.definitions = definitions;
        this.definitionsFile = definitionsFile;
        this.autoStartContainers = autoStartContainers;
        this.proxiedContainerPorts = proxiedContainerPorts;
        this.portForwardBindAddress = portForwardBindAddress;
    }

    public String getOriginServer() {
        return this.originServer;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String getDefinitionsFile() {
        return this.definitionsFile;
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public boolean shouldKeepAliveGitServer() {
        return this.keepAliveGitServer;
    }

    public String[] getAutoStartContainers() {
        if (this.autoStartContainers == null) {
            return new String[0];
        }
        return this.autoStartContainers;
    }

    public Set<String> getProxiedContainerPorts() {
        if (this.proxiedContainerPorts == null) {
            return Collections.emptySet();
        }
        return this.proxiedContainerPorts;
    }

    public String getPortForwardBindAddress() {
        return this.portForwardBindAddress;
    }

    private static String[] split(String str, String regex) {
        if (str == null || str.isEmpty()) {
            return new String[0];
        }
        return str.split(regex);
    }

    public static CubeOpenShiftConfiguration fromMap(Map<String, String> map) {
        try {
            CubeOpenShiftConfiguration conf = ((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)((CubeOpenShiftConfigurationBuilder)new CubeOpenShiftConfigurationBuilder().withOriginServer(ConfigUtil.getStringProperty((String)MASTER_URL, (String)ORIGIN_SERVER, map, (String)FALLBACK_CONFIG.getMasterUrl()))).withNamespace(ConfigUtil.getStringProperty((String)NAMESPACE, map, (String)FALLBACK_CONFIG.getNamespace()))).withKeepAliveGitServer(ConfigUtil.getBooleanProperty((String)KEEP_ALIVE_GIT_SERVER, map, (Boolean)false))).withDefinitions(ConfigUtil.getStringProperty((String)DEFINITIONS, map, null))).withDefinitionsFile(ConfigUtil.getStringProperty((String)DEFINITIONS_FILE, map, null))).withAutoStartContainers(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)AUTO_START_CONTAINERS, map, (String)""), ","))).withProxiedContainerPorts(CubeOpenShiftConfiguration.split(ConfigUtil.getStringProperty((String)PROXIED_CONTAINER_PORTS, map, (String)""), ","))).withPortForwardBindAddress(ConfigUtil.getStringProperty((String)PORT_FORWARDER_BIND_ADDRESS, map, (String)"127.0.0.1"))).build();
            return conf;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

